/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.de.valueset.Country;
import de.gematik.test.erezept.fhir.builder.kbv.KbvMedicalOrganizationBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvMedicalOrganizationFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvMedicalOrganization;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.BSNR;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class KbvMedicalOrganizationBuilderTest
extends ErpFhirParsingTest {
    KbvMedicalOrganizationBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicalOrganization with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildMedicalOrganizationWithFixedValues(KbvItaForVersion version) {
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        KbvMedicalOrganization organization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(version).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Arztpraxis Meyer")).bsnr(BSNR.from((String)"757299999")).phone("+490309876543")).email("info@praxis.de")).address(Country.D, "Berlin", "10623", "Wegelystra\u00dfe 3").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Dental MedicalOrganization with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildDentalMedicalOrganizationWithFixedValues(KbvItaForVersion version) {
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        KbvMedicalOrganization organization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(version).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Zahnarztpraxis Meyer")).kzva("757299999").phone("+490309876543")).email("info@praxis.de")).address(Country.D, "Berlin", "10623", "Wegelystra\u00dfe 3").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Hospital MedicalOrganization with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildHospitalMedicalOrganizationWithFixedValues(KbvItaForVersion version) {
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        KbvMedicalOrganization organization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(version).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Zahnarztpraxis Meyer")).iknr("757299999").phone("+490309876543")).email("info@praxis.de")).address(Country.D, "Berlin", "10623", "Wegelystra\u00dfe 3").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildHospitalKsnMedicalOrganizationWithFixedValues() {
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        KbvMedicalOrganization organization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(KbvItaForVersion.V1_1_0).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Zahnarztpraxis Meyer")).ksn("757299999").phone("+490309876543")).email("info@praxis.de")).address(Country.D, "Berlin", "10623", "Wegelystra\u00dfe 3").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicalOrganization with Faker and KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildMedicalOrganizationWithFaker(KbvItaForVersion version) {
        KbvMedicalOrganization organization = KbvMedicalOrganizationFaker.medicalPractice().withVersion(version).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build empty KBV MedicalOrganization with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void shouldFailOnEmptyMedicalOrganizationBuilder(KbvItaForVersion version) {
        KbvMedicalOrganizationBuilder ob = KbvMedicalOrganizationBuilder.builder().version(version);
        Assertions.assertThrows(BuilderException.class, () -> ((KbvMedicalOrganizationBuilder)ob).build());
    }
}

