/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import com.github.javafaker.service.RandomService;
import de.gematik.bbriccs.fhir.builder.FakerBrick;
import de.gematik.test.erezept.fhir.builder.kbv.KbvHealthAppRequestFaker;
import de.gematik.test.erezept.fhir.r4.kbv.KbvHealthAppRequest;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.AccidentCauseType;
import java.util.Locale;
import java.util.Random;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junitpioneer.jupiter.SetSystemProperty;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

@SetSystemProperty(key="erp.fhir.profile", value="1.4.0")
class KbvHealthAppRequestFakerTest
extends ErpFhirParsingTest {
    KbvHealthAppRequestFakerTest() {
    }

    @Test
    void shouldFakeHealthAppRequest() {
        KbvHealthAppRequest har = KbvHealthAppRequestFaker.forRandomPatient().fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)har);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> HealthAppRequest with Accident Extension for {0}")
    @EnumSource(value=AccidentCauseType.class)
    void shouldFakeHealthAppRequestWithAccident(AccidentCauseType causeType) {
        Random rnd = (Random)Mockito.mock(Random.class);
        RandomService rndService = new RandomService(rnd);
        FakerBrick fakerBrick = (FakerBrick)Mockito.spy((Object)new FakerBrick(Locale.GERMAN, rnd));
        Mockito.when((Object)fakerBrick.random()).thenReturn((Object)rndService);
        Mockito.when((Object)rnd.nextBoolean()).thenReturn((Object)true);
        Mockito.when((Object)((AccidentCauseType)fakerBrick.randomEnum(AccidentCauseType.class))).thenReturn((Object)causeType);
        try (MockedStatic fakerBrickMocker = Mockito.mockStatic(FakerBrick.class);){
            fakerBrickMocker.when(FakerBrick::getGerman).thenReturn((Object)fakerBrick);
            KbvHealthAppRequest har = KbvHealthAppRequestFaker.forRandomPatient().fake();
            ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)har);
            Assertions.assertTrue((boolean)result.isSuccessful());
        }
    }
}

