/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvHealthAppRequestBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPractitionerFaker;
import de.gematik.test.erezept.fhir.extensions.kbv.AccidentExtension;
import de.gematik.test.erezept.fhir.r4.kbv.KbvHealthAppRequest;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import java.util.Date;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.DeviceRequest;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.SetSystemProperty;

@SetSystemProperty(key="erp.fhir.profile", value="1.4.0")
class KbvHealthAppRequestBuilderTest
extends ErpFhirParsingTest {
    KbvHealthAppRequestBuilderTest() {
    }

    @Test
    void shouldBuildHealthAppRequestWithFixedValues() {
        KbvHealthAppRequest har = KbvHealthAppRequestBuilder.forPatient((KbvPatient)KbvPatientFaker.builder().fake()).insurance(KbvCoverageFaker.builder().fake()).requester(KbvPractitionerFaker.builder().fake()).healthApp("17946626", "HelloBetter Schmerzen 001").status(DeviceRequest.DeviceRequestStatus.ACTIVE).intent(DeviceRequest.RequestIntent.ORDER).authoredOn(new Date()).relatesToSocialCompensationLaw(false).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)har);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest
    @MethodSource
    void shouldBuildHealthAppRequestWithFixedValuesWithAccident(AccidentExtension accidentExtension) {
        KbvHealthAppRequest har = KbvHealthAppRequestBuilder.forPatient((KbvPatient)KbvPatientFaker.builder().fake()).insurance(KbvCoverageFaker.builder().fake()).requester(KbvPractitionerFaker.builder().fake()).healthApp("17946626", "HelloBetter Schmerzen 001").accident(accidentExtension).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)har);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    static Stream<Arguments> shouldBuildHealthAppRequestWithFixedValuesWithAccident() {
        return Stream.of(AccidentExtension.accident(), AccidentExtension.accidentAtWork().atWorkplace(), AccidentExtension.occupationalDisease()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

