/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvEvdgaBundleBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvHealthAppRequestFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvMedicalOrganizationFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPractitionerFaker;
import de.gematik.test.erezept.fhir.extensions.kbv.AccidentExtension;
import de.gematik.test.erezept.fhir.r4.kbv.KbvCoverage;
import de.gematik.test.erezept.fhir.r4.kbv.KbvEvdgaBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvMedicalOrganization;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPractitioner;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import de.gematik.test.erezept.fhir.valuesets.QualificationType;
import de.gematik.test.erezept.fhir.valuesets.StatusKennzeichen;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.SetSystemProperty;

@SetSystemProperty(key="erp.fhir.profile", value="1.4.0")
class KbvEvdgaBundleBuilderTest
extends ErpFhirParsingTest {
    KbvEvdgaBundleBuilderTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldBuildKbvEvdgaBundle(QualificationType qualificationType, InsuranceTypeDe insuranceType) {
        KbvPatient patient = KbvPatientFaker.builder().withInsuranceType(InsuranceTypeDe.GKV).fake();
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withQualificationType(qualificationType).fake();
        KbvCoverage insurance = KbvCoverageFaker.builder().withInsuranceType(insuranceType).fake();
        KbvMedicalOrganizationFaker medicalOrgFaker = qualificationType.equals((Object)QualificationType.DENTIST) ? KbvMedicalOrganizationFaker.dentalPractice() : KbvMedicalOrganizationFaker.medicalPractice();
        KbvMedicalOrganization medicalOrg = medicalOrgFaker.fake();
        KbvEvdgaBundle evdgaBundle = ((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)KbvEvdgaBundleBuilder.forPrescription((PrescriptionId)PrescriptionId.random((PrescriptionFlowType)PrescriptionFlowType.FLOW_TYPE_162)).statusKennzeichen(StatusKennzeichen.NONE)).healthAppRequest(KbvHealthAppRequestFaker.forPatient((KbvPatient)patient).withRequester(practitioner).withInsurance(insurance).withoutAccident().fake()).insurance(insurance)).patient(patient)).practitioner(practitioner)).medicalOrganization(medicalOrg)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)evdgaBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    static Stream<Arguments> shouldBuildKbvEvdgaBundle() {
        return Stream.of(Arguments.of((Object[])new Object[]{QualificationType.DOCTOR, InsuranceTypeDe.GKV}), Arguments.of((Object[])new Object[]{QualificationType.DENTIST, InsuranceTypeDe.GKV}), Arguments.of((Object[])new Object[]{QualificationType.DOCTOR, InsuranceTypeDe.SEL}), Arguments.of((Object[])new Object[]{QualificationType.DENTIST, InsuranceTypeDe.SEL}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldBuildKbvEvdgaBundleWithAccident(QualificationType qualificationType, InsuranceTypeDe insuranceType, AccidentExtension accident) {
        KbvPatient patient = KbvPatientFaker.builder().withInsuranceType(InsuranceTypeDe.GKV).fake();
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withQualificationType(qualificationType).fake();
        KbvCoverage insurance = KbvCoverageFaker.builder().withInsuranceType(insuranceType).fake();
        KbvMedicalOrganizationFaker medicalOrgFaker = qualificationType.equals((Object)QualificationType.DENTIST) ? KbvMedicalOrganizationFaker.dentalPractice() : KbvMedicalOrganizationFaker.medicalPractice();
        KbvMedicalOrganization medicalOrg = medicalOrgFaker.fake();
        KbvEvdgaBundle evdgaBundle = ((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)KbvEvdgaBundleBuilder.forPrescription((PrescriptionId)PrescriptionId.random((PrescriptionFlowType)PrescriptionFlowType.FLOW_TYPE_162)).healthAppRequest(KbvHealthAppRequestFaker.forPatient((KbvPatient)patient).withRequester(practitioner).withInsurance(insurance).withAccident(accident).fake()).insurance(insurance)).patient(patient)).practitioner(practitioner)).medicalOrganization(medicalOrg)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)evdgaBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    static Stream<Arguments> shouldBuildKbvEvdgaBundleWithAccident() {
        return Stream.of(Arguments.of((Object[])new Object[]{QualificationType.DOCTOR, InsuranceTypeDe.GKV, AccidentExtension.accident()}), Arguments.of((Object[])new Object[]{QualificationType.DOCTOR, InsuranceTypeDe.BG, AccidentExtension.occupationalDisease()}), Arguments.of((Object[])new Object[]{QualificationType.DOCTOR, InsuranceTypeDe.BG, AccidentExtension.accidentAtWork().atWorkplace()}), Arguments.of((Object[])new Object[]{QualificationType.DENTIST, InsuranceTypeDe.GKV, AccidentExtension.accident()}), Arguments.of((Object[])new Object[]{QualificationType.DENTIST, InsuranceTypeDe.BG, AccidentExtension.occupationalDisease()}), Arguments.of((Object[])new Object[]{QualificationType.DENTIST, InsuranceTypeDe.BG, AccidentExtension.accidentAtWork().atWorkplace()}));
    }

    @ParameterizedTest
    @EnumSource(value=KbvMedicalOrganizationFaker.OrganizationFakerType.class, names={"HOSPITAL", "HOSPITAL_KSN"})
    void shouldBuildKbvEvdgaBundleForHospital(KbvMedicalOrganizationFaker.OrganizationFakerType orgType) {
        InsuranceTypeDe insuranceType = InsuranceTypeDe.GKV;
        KbvPatient patient = KbvPatientFaker.builder().withInsuranceType(insuranceType).fake();
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withQualificationType(QualificationType.DOCTOR_AS_REPLACEMENT).fake();
        KbvPractitioner attester = KbvPractitionerFaker.builder().withQualificationType(QualificationType.DOCTOR).fake();
        KbvCoverage insurance = KbvCoverageFaker.builder().withInsuranceType(insuranceType).fake();
        KbvMedicalOrganization medicalOrg = KbvMedicalOrganizationFaker.builder((KbvMedicalOrganizationFaker.OrganizationFakerType)orgType).fake();
        KbvEvdgaBundle evdgaBundle = ((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)((KbvEvdgaBundleBuilder)KbvEvdgaBundleBuilder.forPrescription((PrescriptionId)PrescriptionId.random((PrescriptionFlowType)PrescriptionFlowType.FLOW_TYPE_162)).healthAppRequest(KbvHealthAppRequestFaker.forPatient((KbvPatient)patient).withRequester(practitioner).withInsurance(insurance).withoutAccident().fake()).insurance(insurance)).patient(patient)).practitioner(practitioner)).attester(attester)).medicalOrganization(medicalOrg)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)evdgaBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

