/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationRequestFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPractitionerFaker;
import de.gematik.test.erezept.fhir.extensions.kbv.AccidentExtension;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedicationRequest;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.StatusCoPayment;
import java.util.Date;
import java.util.Optional;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvErpMedicationRequestFakerTest
extends ErpFhirParsingTest {
    KbvErpMedicationRequestFakerTest() {
    }

    @Test
    void buildFakerMedicationRequestWithVersion() {
        KbvErpMedicationRequest medication = KbvErpMedicationRequestFaker.builder().withVersion(KbvItaErpVersion.getDefaultVersion()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithMedication() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().fake();
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withMedication(KbvErpMedication.fromMedication((Medication)medication)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithRequester() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withRequester(KbvPractitionerFaker.builder().fake()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithInsurance() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withInsurance(KbvCoverageFaker.builder().fake()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithAccident() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withAccident(AccidentExtension.faker()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithStatus() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withStatus(MedicationRequest.MedicationRequestStatus.ACTIVE).fake();
        KbvErpMedicationRequest medicationRequest2 = KbvErpMedicationRequestFaker.builder().withStatus("active").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithIntent() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withIntent(MedicationRequest.MedicationRequestIntent.ORDER).fake();
        KbvErpMedicationRequest medicationRequest2 = KbvErpMedicationRequestFaker.builder().withIntent("order").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithSubstitution() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withSubstitution(new MedicationRequest.MedicationRequestSubstitutionComponent()).fake();
        KbvErpMedicationRequest medicationRequest2 = KbvErpMedicationRequestFaker.builder().withSubstitution(GemFaker.fakerBool()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithQuantity() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withQuantity(new Quantity()).fake();
        KbvErpMedicationRequest medicationRequest2 = KbvErpMedicationRequestFaker.builder().withQuantity(new MedicationRequest.MedicationRequestDispenseRequestComponent()).fake();
        KbvErpMedicationRequest medicationRequest3 = KbvErpMedicationRequestFaker.builder().withQuantityPackages(GemFaker.fakerAmount()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest2);
        ValidationResult result3 = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest3);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
        Assertions.assertTrue((boolean)result3.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithDosageInstruction() {
        String dosageText = "Dosage Instruction";
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withDosageInstruction("Dosage Instruction").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)"Dosage Instruction", (Object)((Dosage)medicationRequest.getDosageInstruction().get(0)).getText());
    }

    @Test
    void buildFakerMedicationRequestWithCoPaymentStatus() {
        StatusCoPayment status = StatusCoPayment.STATUS_0;
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withCoPaymentStatus(status).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals(Optional.of(status), (Object)medicationRequest.getCoPaymentStatus());
    }

    @Test
    void buildFakerMedicationRequestWithBvg() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withBvg(GemFaker.fakerBool()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithEmergencyServiceFee() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withEmergencyServiceFee(GemFaker.fakerBool()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithMvo() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withMvo(GemFaker.mvo()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithAuthorDate() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withAuthorDate(new Date()).fake();
        KbvErpMedicationRequest medicationRequest2 = KbvErpMedicationRequestFaker.builder().withAuthorDate(new Date(), TemporalPrecisionEnum.DAY).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakerMedicationRequestWithNote() {
        String noteText = "This is note";
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withNote("This is note").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals(Optional.of("This is note"), (Object)medicationRequest.getNoteText());
    }

    @Test
    void buildFakerMedicationRequestWithPatient() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withPatient(KbvPatientFaker.builder().fake()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

