/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationRequestBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationRequestFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPractitionerFaker;
import de.gematik.test.erezept.fhir.extensions.kbv.AccidentExtension;
import de.gematik.test.erezept.fhir.extensions.kbv.MultiplePrescriptionExtension;
import de.gematik.test.erezept.fhir.parser.profiles.definitions.KbvItaErpStructDef;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedicationRequest;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.StatusCoPayment;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class KbvErpMedicationRequestBuilderTest
extends ErpFhirParsingTest {
    KbvErpMedicationRequestBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationRequest with Accident in versions KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationRequestWithoutDosageInstruction(KbvItaErpVersion version) {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestBuilder.forPatient((KbvPatient)KbvPatientFaker.builder().fake()).version(version).insurance(KbvCoverageFaker.builder().fake()).requester(KbvPractitionerFaker.builder().fake()).medication(KbvErpMedicationPZNFaker.builder().fake()).quantityPackages(20).status("active").intent("order").isBVG(false).hasEmergencyServiceFee(true).substitution(false).coPaymentStatus(StatusCoPayment.STATUS_0).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Dosage dosage = medicationRequest.getDosageInstructionFirstRep();
        Assertions.assertFalse((boolean)dosage.hasText());
        Assertions.assertFalse((boolean)medicationRequest.hasNote());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationRequest with Accident in versions KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationRequestAndSkipEmptyDosageInstruction(KbvItaErpVersion version) {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withVersion(version).withDosageInstruction("").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Dosage dosage = medicationRequest.getDosageInstructionFirstRep();
        Assertions.assertFalse((boolean)dosage.hasText());
        Extension dosageExtension = dosage.getExtensionByUrl(KbvItaErpStructDef.DOSAGE_FLAG.getCanonicalUrl());
        BooleanType hasDosageInstruction = dosageExtension.getValue().castToBoolean((Base)dosageExtension.getValue());
        Assertions.assertFalse((boolean)hasDosageInstruction.booleanValue());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationRequest with Accident in versions KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationRequestWithAccident(KbvItaErpVersion version) {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withVersion(version).withAccident(AccidentExtension.accident()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationRequest with CoPayment Status in versions KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationRequestWithStatusCoPayment(KbvItaErpVersion version) {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withVersion(version).withCoPaymentStatus(StatusCoPayment.STATUS_0).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)medicationRequest.getCoPaymentStatus().isPresent());
        Assertions.assertEquals((Object)StatusCoPayment.STATUS_0, medicationRequest.getCoPaymentStatus().get());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationRequest with Accident at Work in versions KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationRequestWithAccidentAtWork(KbvItaErpVersion version) {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withVersion(version).withAccident(AccidentExtension.accidentAtWork().atWorkplace()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationRequest with Accident at Work in versions KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationRequestWithOccupationalDisease(KbvItaErpVersion version) {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withVersion(version).withAccident(AccidentExtension.occupationalDisease()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationRequest with random Accident in versions KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationRequestWithFakerAccident(KbvItaErpVersion version) {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withVersion(version).withAccident(AccidentExtension.faker()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationRequest with random Accident in versions KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationRequestWithRandomMvoIdentifier(KbvItaErpVersion version) {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withVersion(version).withMvo(MultiplePrescriptionExtension.asMultiple((int)1, (int)4).withRandomId().validForDays(365)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
        if (version.compareTo((Enum)KbvItaErpVersion.V1_0_2) > 0) {
            Assertions.assertTrue((boolean)medicationRequest.getMvoId().isPresent());
        }
    }

    @ParameterizedTest(name="[{index}] -> Build random KBV MedicationRequest with faker in versions KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationRequestWithFaker(KbvItaErpVersion version) {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withVersion(version).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationRequest);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldUseUnknownStatusOnInvalidCode() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withStatus("abc").fake();
        Assertions.assertEquals((Object)MedicationRequest.MedicationRequestStatus.UNKNOWN, (Object)medicationRequest.getStatus());
    }

    @Test
    void shouldUseNullIntentOnInvalidCode() {
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withIntent("abc").fake();
        Assertions.assertEquals((Object)MedicationRequest.MedicationRequestIntent.NULL, (Object)medicationRequest.getIntent());
    }
}

