/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.BaseMedicationType;
import de.gematik.test.erezept.fhir.valuesets.Darreichungsform;
import de.gematik.test.erezept.fhir.valuesets.StandardSize;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvErpMedicationPZNFakerTest
extends ErpFhirParsingTest {
    KbvErpMedicationPZNFakerTest() {
    }

    @Test
    void buildFakerKbvErpMedicationPZNWithType() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withType(BaseMedicationType.MEDICAL_PRODUCT).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerKbvErpMedicationPZNWithVaccine() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withVaccine(GemFaker.fakerBool()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerKbvErpMedicationPZNWithStandardSize() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withStandardSize((StandardSize)GemFaker.fakerValueSet(StandardSize.class)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldFakeKbvErpMedicationPznWithSupplyForm() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withSupplyForm(Darreichungsform.SCH).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerKbvErpMedicationPZNWithPZNMedicationName() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withPznMedication(PZN.random(), GemFaker.fakerDrugName()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerKbvErpMedicationPZNWithAmount() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withAmount((long)GemFaker.fakerAmount()).fake();
        KbvErpMedication medication2 = KbvErpMedicationPZNFaker.builder().withAmount((long)GemFaker.fakerAmount(), "Stk").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)medication2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }
}

