/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.Darreichungsform;
import de.gematik.test.erezept.fhir.valuesets.MedicationCategory;
import de.gematik.test.erezept.fhir.valuesets.StandardSize;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class KbvErpMedicationPZNBuilderTest
extends ErpFhirParsingTest {
    KbvErpMedicationPZNBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Medication with KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationWithFixedValues(KbvItaErpVersion version) {
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        KbvErpMedication medication = ((KbvErpMedicationPZNBuilder)KbvErpMedicationPZNBuilder.builder().version(version).setId("c1e7027e-3c5b-4e87-a10a-572676b92e22")).category(MedicationCategory.C_00).isVaccine(false).normgroesse(StandardSize.N1).darreichungsform(Darreichungsform.TKA).amount(5L, "Stk").pzn("04773414", "Doxycyclin AL 200 T, 10 Tabletten N1").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Medication with KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationWithFixedValuesAndPackagingSize(KbvItaErpVersion version) {
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        KbvErpMedication medication = ((KbvErpMedicationPZNBuilder)KbvErpMedicationPZNBuilder.builder().version(version).setId("c1e7027e-3c5b-4e87-a10a-572676b92e22")).category(MedicationCategory.C_00).isVaccine(false).normgroesse(StandardSize.N1).darreichungsform(Darreichungsform.TKA).packagingSize("5x3").pzn("04773414", "Doxycyclin AL 200 T, 10 Tabletten N1").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Medication with KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationWithFixedValues2(KbvItaErpVersion version) {
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        KbvErpMedication medication = ((KbvErpMedicationPZNBuilder)KbvErpMedicationPZNBuilder.builder().version(version).setId("c1e7027e-3c5b-4e87-a10a-572676b92e22")).category(MedicationCategory.C_00).isVaccine(false).normgroesse(StandardSize.N1).darreichungsform(Darreichungsform.TKA).pzn(PZN.random(), "5 in 1 Medikament").amount(4L).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Medication with Faker for KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildMedicationWithFakerAndValidValues(KbvItaErpVersion version) {
        PZN randomPZN = PZN.random();
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withPznMedication((String)randomPZN.getValue(), "Test Medikament").withCategory(MedicationCategory.C_00).withVersion(version).fake();
        Assertions.assertNotNull((Object)medication);
        Assertions.assertNotNull((Object)medication.getCode());
        Assertions.assertEquals((Object)"Test Medikament", (Object)medication.getCode().getText());
        Assertions.assertFalse((boolean)medication.getForm().getCoding().stream().anyMatch(coding -> coding.getCode().equals(Darreichungsform.PUE.getCode()) || coding.getCode().equals(Darreichungsform.LYE.getCode())), (String)"Excluded Darreichungsformen PUE and LYE should not be used before April 2025");
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

