/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationIngredientFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.MedicationCategory;
import de.gematik.test.erezept.fhir.valuesets.StandardSize;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvErpMedicationIngredientFakerTest
extends ErpFhirParsingTest {
    KbvErpMedicationIngredientFakerTest() {
    }

    @Test
    void buildFakerKbvErpMedicationIngredientWithVaccine() {
        KbvErpMedication ingredient = KbvErpMedicationIngredientFaker.builder().withVaccine(GemFaker.fakerBool()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)ingredient);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerKbvErpMedicationIngredientWithVersion() {
        KbvErpMedication ingredient = KbvErpMedicationIngredientFaker.builder().withVersion(KbvItaErpVersion.getDefaultVersion()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)ingredient);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerKbvErpMedicationIngredientWithCategory() {
        KbvErpMedication ingredient = KbvErpMedicationIngredientFaker.builder().withCategory((MedicationCategory)GemFaker.fakerValueSet(MedicationCategory.class)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)ingredient);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerKbvErpMedicationIngredientWithAmount() {
        String numerator = "num";
        KbvErpMedication ingredient = KbvErpMedicationIngredientFaker.builder().withAmount(numerator).fake();
        KbvErpMedication ingredient2 = KbvErpMedicationIngredientFaker.builder().withAmount(numerator, "Stk").fake();
        KbvErpMedication ingredient3 = KbvErpMedicationIngredientFaker.builder().withAmount(numerator, 1L, "Stk").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)ingredient);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)ingredient2);
        ValidationResult result3 = ValidatorUtil.encodeAndValidate(parser, (Resource)ingredient3);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
        Assertions.assertTrue((boolean)result3.isSuccessful());
    }

    @Test
    void buildFakerKbvErpMedicationIngredientWithIngredient() {
        KbvErpMedication ingredient = KbvErpMedicationIngredientFaker.builder().withIngredientComponent("Fake Unit").fake();
        KbvErpMedication ingredient2 = KbvErpMedicationIngredientFaker.builder().withIngredientComponent(0L, 1L, "Fake Unit").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)ingredient);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)ingredient2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakerKbvErpMedicationIngredientWithStandardSize() {
        KbvErpMedication ingredient = KbvErpMedicationIngredientFaker.builder().withStandardSize((StandardSize)GemFaker.fakerValueSet(StandardSize.class)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)ingredient);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

