/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationIngredientBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationIngredientFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.MedicationCategory;
import de.gematik.test.erezept.fhir.valuesets.StandardSize;
import java.math.BigDecimal;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class KbvErpMedicationIngredientBuilderTest
extends ErpFhirParsingTest {
    KbvErpMedicationIngredientBuilderTest() {
    }

    @Test
    void shouldBuildCorrect() {
        KbvErpMedication mI = KbvErpMedicationIngredientBuilder.builder().darreichungsform("aufs Auge").ingredientComponent(3L, 1L, "w\u00f6lkchen").drugName("MonsterPille").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldFakeCorrect() {
        KbvErpMedication mI = KbvErpMedicationIngredientFaker.builder().fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldFakeCorrectWithDrugName() {
        String drugName = "TestName";
        KbvErpMedication mI = KbvErpMedicationIngredientFaker.builder().withDrugName("TestName").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertEquals((Object)"TestName", (Object)((Base)mI.getIngredientFirstRep().getItem().getChildByName("text").getValues().get(0)).toString());
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldFakeCorrectWithDrugNameAndConsumeDescription() {
        String drugName = "TestName";
        String darreichung = "darreichungsform";
        KbvErpMedication mI = KbvErpMedicationIngredientFaker.builder().withDosageForm("darreichungsform").withDrugName("TestName").fake();
        Assertions.assertEquals((Object)"TestName", (Object)((Base)mI.getIngredientFirstRep().getItem().getChildByName("text").getValues().get(0)).toString());
        Assertions.assertEquals((Object)"darreichungsform", (Object)mI.getForm().getText());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationIngredient with KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldSetCorrectVersion(KbvItaErpVersion version) {
        KbvErpMedication mI = KbvErpMedicationIngredientBuilder.builder().version(version).drugName("fancyName").darreichungsform("10 Tropfen 1-0-1-0").ingredientComponent("Tropfen").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)version, (Object)mI.getVersion());
        Assertions.assertEquals((Object)"Tropfen", (Object)mI.getIngredientFirstRep().getStrength().getNumerator().getUnit());
    }

    @Test
    void shouldSetCorrectCategory() {
        KbvErpMedication mI = KbvErpMedicationIngredientBuilder.builder().drugName("fancyName").darreichungsform("10 Tropfen 1-0-1-0").ingredientComponent("Tropfen").category(MedicationCategory.C_00).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)MedicationCategory.C_00, (Object)mI.getCategoryFirstRep());
    }

    @Test
    void shouldSetCorrectVaccine() {
        KbvErpMedication mI = KbvErpMedicationIngredientBuilder.builder().drugName("fancyName").darreichungsform("10 Tropfen 1-0-1-0").ingredientComponent("Tropfen").isVaccine(true).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)mI.isVaccine());
    }

    @Test
    void shouldSetCorrectStandardSize() {
        KbvErpMedication mI = KbvErpMedicationIngredientBuilder.builder().drugName("fancyName").darreichungsform("10 Tropfen 1-0-1-0").ingredientComponent("Tropfen").normGroesse(StandardSize.NB).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)StandardSize.NB, (Object)mI.getStandardSize());
    }

    @Test
    void shouldSetCorrectAmount() {
        KbvErpMedication mI = KbvErpMedicationIngredientBuilder.builder().drugName("fancyName").darreichungsform("10 Tropfen 1-0-1-0").ingredientComponent("Tropfen").amount("5").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)"5", (Object)mI.getAmount().getNumerator().getExtensionFirstRep().getValue().toString());
    }

    @Test
    void shouldSetCorrectAmount2() {
        KbvErpMedication mI = KbvErpMedicationIngredientBuilder.builder().drugName("fancyName").darreichungsform("10 Tropfen 1-0-1-0").ingredientComponent("Tropfen").amount("5", 1L, "Schokotaler").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)"5", (Object)mI.getAmount().getNumerator().getExtensionFirstRep().getValue().toString());
        Assertions.assertEquals((Object)"Schokotaler", (Object)mI.getAmount().getNumerator().getUnit());
        Assertions.assertEquals((int)1, (int)mI.getAmount().getDenominator().getValue().intValue());
    }

    @Test
    void shouldSetCorrectAmount3() {
        KbvErpMedication mI = KbvErpMedicationIngredientBuilder.builder().drugName("fancyName").darreichungsform("10 Tropfen 1-0-1-0").ingredientComponent("Tropfen").amount("5", "Schokotaler").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)"5", (Object)mI.getAmount().getNumerator().getExtensionFirstRep().getValue().toString());
        Assertions.assertEquals((Object)"Schokotaler", (Object)mI.getAmount().getNumerator().getUnit());
    }

    @Test
    void shouldCheckRequired() {
        KbvErpMedicationIngredientBuilder builder = KbvErpMedicationIngredientBuilder.builder();
        Assertions.assertThrows(BuilderException.class, () -> ((KbvErpMedicationIngredientBuilder)builder).build());
    }

    @Test
    void shouldSetCorrectDarreichung() {
        KbvErpMedication mI = KbvErpMedicationIngredientBuilder.builder().drugName("fancyName").ingredientComponent("Tropfen").darreichungsform("DR").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertEquals((Object)"DR", (Object)mI.getForm().getText());
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldSetCorrectIngredient() {
        KbvErpMedication mI = KbvErpMedicationIngredientBuilder.builder().drugName("fancyName").darreichungsform("10 Tropfen 1-0-1-0").ingredientComponent(3L, 1L, "b\u00e4lle").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)mI);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)BigDecimal.valueOf(3L), (Object)mI.getIngredientFirstRep().getStrength().getNumerator().getValue());
    }
}

