/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationFreeTextFaker;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.Darreichungsform;
import de.gematik.test.erezept.fhir.valuesets.MedicationCategory;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvErpMedicationFreeTextFakerTest
extends ErpFhirParsingTest {
    KbvErpMedicationFreeTextFakerTest() {
    }

    @Test
    void buildFakeMedicationFreeTextWithDosageForm() {
        KbvErpMedication freetext = KbvErpMedicationFreeTextFaker.builder().withDosageForm(((Darreichungsform)GemFaker.fakerValueSet(Darreichungsform.class)).getCode()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)freetext);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeMedicationFreeTextWithVaccine() {
        KbvErpMedication freetext = KbvErpMedicationFreeTextFaker.builder().withVaccine(GemFaker.fakerBool()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)freetext);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFAkeMedicationFreeTextWithCategory() {
        KbvErpMedication freetext = KbvErpMedicationFreeTextFaker.builder().withCategory(MedicationCategory.C_00).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)freetext);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void fakerShouldWork() {
        KbvErpMedication medFreeText = KbvErpMedicationFreeTextFaker.builder().fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medFreeText);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void fakerWithTextShouldWork() {
        KbvErpMedication medFreeText = KbvErpMedicationFreeTextFaker.builder().withFreeText("3 mal t\u00e4glich einen lutscher lutschen und anschlie\u00dfend Z\u00e4hnchen putzen").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medFreeText);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

