/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationFreeTextBuilder;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.MedicationCategory;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class KbvErpMedicationFreeTextBuilderTest
extends ErpFhirParsingTest {
    KbvErpMedicationFreeTextBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationFreeText with KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildWithKbvVersion(KbvItaErpVersion version) {
        KbvErpMedication medicationFreeText = new KbvErpMedicationFreeTextBuilder().version(version).freeText("Nasenst\u00f6psel w\u00e4hrend des Nase putzens entfernen.").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationFreeText);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)version, (Object)medicationFreeText.getVersion());
    }

    @Test
    void builderShouldWork() {
        KbvErpMedication medicationFreeText = new KbvErpMedicationFreeTextBuilder().category(MedicationCategory.C_00).isVaccine(true).darreichung("NasenSt\u00f6psel").freeText("Nasenst\u00f6psel w\u00e4hrend des Nase putzens entfernen.").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationFreeText);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void builderShouldWorkWithoutDarreichungsform() {
        KbvErpMedication medicationFreeText = new KbvErpMedicationFreeTextBuilder().category(MedicationCategory.C_00).isVaccine(true).freeText("Nasenst\u00f6psel w\u00e4hrend des Nase putzens entfernen.").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationFreeText);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void requiredEntriesShouldBeChecked() {
        KbvErpMedicationFreeTextBuilder builder = KbvErpMedicationFreeTextBuilder.builder();
        Assertions.assertThrows(BuilderException.class, () -> {
            KbvErpMedication test1 = builder.build();
        });
    }
}

