/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationCompoundingFaker;
import de.gematik.test.erezept.fhir.extensions.kbv.ProductionInstruction;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.Darreichungsform;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvErpMedicationCompoundingFakerTest
extends ErpFhirParsingTest {
    KbvErpMedicationCompoundingFakerTest() {
    }

    @Test
    void buildFakeKbvErpMedicationCompoundingWithDosageForm() {
        KbvErpMedication medication = KbvErpMedicationCompoundingFaker.builder().withPackaging("fass").withDosageForm("Z\u00e4pfchen, viel Spa\u00df").fake();
        KbvErpMedication medication2 = KbvErpMedicationCompoundingFaker.builder().withProductionInstruction("mischen").withDosageForm(Darreichungsform.AEO).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)medication2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakeKbvErpMedicationCompoundingWithAmount() {
        KbvErpMedication medication = KbvErpMedicationCompoundingFaker.builder().withAmount((long)GemFaker.fakerAmount()).withPackaging("fass").fake();
        KbvErpMedication medication2 = KbvErpMedicationCompoundingFaker.builder().withProductionInstruction("mischen").withAmount(5L, 1L, "Stk").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)medication2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakeKbvErpMedicationCompoundingWithVaccine() {
        KbvErpMedication medication = KbvErpMedicationCompoundingFaker.builder().withProductionInstruction("mischen").withVaccine(GemFaker.fakerBool()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvErpMedicationCompoundingWithProductionInstruction() {
        KbvErpMedication medication = KbvErpMedicationCompoundingFaker.builder().withPackaging("fass").withProductionInstruction(ProductionInstruction.asCompounding((String)"freitext")).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvErpMedicationCompoundingWithMedicationIngredient() {
        KbvErpMedication medication = KbvErpMedicationCompoundingFaker.builder().withPackaging("Fassabf\u00fcllung").withMedicationIngredient((String)PZN.random().getValue(), GemFaker.fakerDrugName()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

