/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationCompoundingBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationCompoundingFaker;
import de.gematik.test.erezept.fhir.extensions.kbv.ProductionInstruction;
import de.gematik.test.erezept.fhir.parser.profiles.definitions.KbvItaErpStructDef;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.Darreichungsform;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class KbvErpMedicationCompoundingBuilderTest
extends ErpFhirParsingTest {
    KbvErpMedicationCompoundingBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build KBV MedicationCompounding with KbvItaErpVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldBuildWithKbvVersion(KbvItaErpVersion version) {
        KbvErpMedication medicationCompounding = KbvErpMedicationCompoundingBuilder.builder().productionInstruction(ProductionInstruction.asCompounding((String)"freitext Z.B. ger\u00fchrt nicht gesch\u00fcttelt")).medicationIngredient("11260676", "Fancy Salbe", "freitextInPzn").version(version).amount(123456L).darreichungsform(Darreichungsform.AEO).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationCompounding);
        Assertions.assertTrue((boolean)medicationCompounding.getExtension().stream().filter(xva$0 -> KbvItaErpStructDef.COMPOUNDING_INSTRUCTION.matches(new Extension[]{xva$0})).findAny().stream().findFirst().isPresent());
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void fakerShouldWork() {
        KbvErpMedication medComp = KbvErpMedicationCompoundingFaker.builder().fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medComp);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest
    @ValueSource(strings={"Comp", "Package", "null"})
    void shouldBuildAsCompoundingAndPackage(String bool) {
        ProductionInstruction productionInstruction = null;
        if (bool.equals("Comp")) {
            productionInstruction = ProductionInstruction.asCompounding((String)"freitext Z.B.: ger\u00fchrt nicht gesch\u00fcttelt");
        } else if (bool.equals("Package")) {
            productionInstruction = ProductionInstruction.asPackaging((String)"freitext Z.B.: Achtung! jetzt kommt ein Karton!!!");
        }
        KbvErpMedicationCompoundingBuilder medicationCompounding = KbvErpMedicationCompoundingBuilder.builder().productionInstruction(productionInstruction).darreichungsform("Nasentropfen").medicationIngredient("11260676", "Fancy Salbe").amount(1L);
        if (productionInstruction != null) {
            ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationCompounding.build());
            Assertions.assertTrue((boolean)result.isSuccessful());
        } else {
            Assertions.assertThrows(BuilderException.class, () -> ((KbvErpMedicationCompoundingBuilder)medicationCompounding).build());
        }
    }

    @Test
    void fakerWithoutRequiredShouldThrowException1() {
        KbvErpMedicationCompoundingBuilder builder = KbvErpMedicationCompoundingBuilder.builder();
        Assertions.assertThrows(BuilderException.class, () -> ((KbvErpMedicationCompoundingBuilder)builder).build());
    }

    @Test
    void fakerWithoutRequiredShouldThrowException2() {
        KbvErpMedicationCompoundingBuilder builder2 = KbvErpMedicationCompoundingBuilder.builder().productionInstruction(ProductionInstruction.random());
        Assertions.assertThrows(BuilderException.class, () -> ((KbvErpMedicationCompoundingBuilder)builder2).build());
    }

    @Test
    void fakerWithoutRequiredShouldThrowException3() {
        KbvErpMedicationCompoundingBuilder builder3 = KbvErpMedicationCompoundingBuilder.builder().productionInstruction(ProductionInstruction.random());
        Assertions.assertThrows(BuilderException.class, () -> ((KbvErpMedicationCompoundingBuilder)builder3).build());
    }

    @Test
    void fakerWithoutRequiredShouldThrowException4() {
        KbvErpMedicationCompoundingBuilder builder4 = KbvErpMedicationCompoundingBuilder.builder().medicationIngredient("p", "pp");
        Assertions.assertThrows(BuilderException.class, () -> ((KbvErpMedicationCompoundingBuilder)builder4).build());
    }

    @Test
    void fakerWithoutRequiredShouldThrowException() {
        KbvErpMedicationCompoundingBuilder builder5 = KbvErpMedicationCompoundingBuilder.builder().darreichungsform("Z\u00e4pfchen");
        Assertions.assertThrows(BuilderException.class, () -> ((KbvErpMedicationCompoundingBuilder)builder5).build());
    }

    @Test
    void fakerWithoutRequiredShouldThrowException5() {
        KbvErpMedicationCompoundingBuilder builder5 = KbvErpMedicationCompoundingBuilder.builder().darreichungsform("Z\u00e4pfchen").medicationIngredient((String)PZN.random().getValue(), "testText");
        Assertions.assertThrows(BuilderException.class, () -> ((KbvErpMedicationCompoundingBuilder)builder5).build());
    }

    @Test
    void fakerWithoutRequiredShouldThrowExceptionWhilePackagingAndProductionInstruction() {
        KbvErpMedicationCompoundingBuilder builder5 = KbvErpMedicationCompoundingBuilder.builder().darreichungsform("Z\u00e4pfchen").medicationIngredient((String)PZN.random().getValue(), "testText").productionInstruction(ProductionInstruction.random()).packaging("packung");
        Assertions.assertThrows(BuilderException.class, () -> ((KbvErpMedicationCompoundingBuilder)builder5).build());
    }
}

