/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.bbriccs.fhir.ucum.builder.QuantityBuilder;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpBundleFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPractitionerFaker;
import de.gematik.test.erezept.fhir.extensions.kbv.AccidentExtension;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.valuesets.QualificationType;
import de.gematik.test.erezept.fhir.valuesets.StatusCoPayment;
import de.gematik.test.erezept.fhir.valuesets.StatusKennzeichen;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvErpBundleFakerTest
extends ErpFhirParsingTest {
    KbvErpBundleFakerTest() {
    }

    @Test
    void buildFakeKbvErpBundleWithPrescriptionId() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withPrescriptionId(PrescriptionId.random()).fake();
        KbvErpBundle bundle2 = KbvErpBundleFaker.builder().withPrescriptionId((String)PrescriptionId.random().getValue()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakeKbvErpBundleWithStatusKennzeichen() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withStatusKennzeichen(((StatusKennzeichen)GemFaker.fakerValueSet(StatusKennzeichen.class)).getCode()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvEprBundleWithKvnr() {
        KVNR kvnr = KVNR.random();
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withKvnr(kvnr).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)kvnr.getValue(), (Object)bundle.getPatient().getKvnr().getValue());
    }

    @Test
    void buildFakeKbvEprBundleWithPatient() {
        KbvPatient patient = KbvPatientFaker.builder().withKvnrAndInsuranceType(KVNR.random(), InsuranceTypeDe.GKV).fake();
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withPatient(patient).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertEquals((int)patient.hashCode(), (int)bundle.getPatient().hashCode());
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvErpBundleWithDosageInstruction() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withDosageInstruction("di").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)"di", (Object)bundle.getMedicationRequest().getDosageInstructionFirstRep().getText());
    }

    @Test
    void buildFakeKbvErpBundleWithBvg() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withBvg(true).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)bundle.getMedicationRequest().isBvg());
    }

    @Test
    void buildFakeKbvErpBundleWithEmergencyServiceFee() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withEmergencyServiceFee(true).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)bundle.getMedicationRequest().hasEmergencyServiceFee());
    }

    @Test
    void buildFakeKbvErpBundleWithAccident() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withAccident(AccidentExtension.accident()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvErpBundleWithMedicationRequestVersion() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withVersion(KbvItaErpVersion.getDefaultVersion(), KbvItaForVersion.getDefaultVersion()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvErpBundleWithQuantity() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withQuantity(new MedicationRequest.MedicationRequestDispenseRequestComponent()).fake();
        KbvErpBundle bundle2 = KbvErpBundleFaker.builder().withQuantity(QuantityBuilder.asUcumPackage().withValue(GemFaker.fakerAmount())).fake();
        KbvErpBundle bundle3 = KbvErpBundleFaker.builder().withQuantityPackages(GemFaker.fakerAmount()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle2);
        ValidationResult result3 = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle3);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
        Assertions.assertTrue((boolean)result3.isSuccessful());
    }

    @Test
    void buildFakeKbvErpBundleWithCoPaymentStatus() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withCoPaymentStatus((StatusCoPayment)GemFaker.fakerValueSet(StatusCoPayment.class)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvErpBundleWithNote() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withNote("note").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)"note", (Object)bundle.getMedicationRequest().getNoteText().orElse(""));
    }

    @Test
    void buildFakeKbvErpBundleWithIntent() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withIntent(MedicationRequest.MedicationRequestIntent.ORDER.toCode()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)"order", (Object)bundle.getMedicationRequest().getIntent().toCode());
    }

    @Test
    void buildFakeKbvErpBundleWithSubstitution() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withSubstitution(true).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)bundle.getMedicationRequest().allowSubstitution());
    }

    @Test
    void buildFakeKbvErpBundleWithAttester() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withPractitioner(KbvPractitionerFaker.builder().withQualificationType(QualificationType.DOCTOR_IN_TRAINING).fake()).withAttester(KbvPractitionerFaker.builder().fake()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvErpBundleWithStatus() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withStatus(MedicationRequest.MedicationRequestStatus.ACTIVE).fake();
        KbvErpBundle bundle2 = KbvErpBundleFaker.builder().withStatus("active").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakeKbvErpBundleWithMvo() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().withMvo(GemFaker.mvo()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

