/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.coding.version.ProfileVersion;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.bbriccs.fhir.de.valueset.Country;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvAssignerOrganizationBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvAssignerOrganizationFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpBundleBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpBundleFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationCompoundingFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationFreeTextFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationRequestBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationRequestFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvMedicalOrganizationBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvMedicalOrganizationFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPractitionerBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPractitionerFaker;
import de.gematik.test.erezept.fhir.builder.kbv.SupplyRequestBuilder;
import de.gematik.test.erezept.fhir.extensions.kbv.AccidentExtension;
import de.gematik.test.erezept.fhir.extensions.kbv.MultiplePrescriptionExtension;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import de.gematik.test.erezept.fhir.r4.InstitutionalOrganization;
import de.gematik.test.erezept.fhir.r4.kbv.AssignerOrganization;
import de.gematik.test.erezept.fhir.r4.kbv.KbvCoverage;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedicationRequest;
import de.gematik.test.erezept.fhir.r4.kbv.KbvMedicalOrganization;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPractitioner;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.AsvFachgruppennummer;
import de.gematik.test.erezept.fhir.values.BaseANR;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.valuesets.Darreichungsform;
import de.gematik.test.erezept.fhir.valuesets.DmpKennzeichen;
import de.gematik.test.erezept.fhir.valuesets.MedicationCategory;
import de.gematik.test.erezept.fhir.valuesets.PersonGroup;
import de.gematik.test.erezept.fhir.valuesets.QualificationType;
import de.gematik.test.erezept.fhir.valuesets.StandardSize;
import de.gematik.test.erezept.fhir.valuesets.StatusCoPayment;
import de.gematik.test.erezept.fhir.valuesets.StatusKennzeichen;
import de.gematik.test.erezept.fhir.valuesets.VersichertenStatus;
import de.gematik.test.erezept.fhir.valuesets.Wop;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KbvErpBundleBuilderTest
extends ErpFhirParsingTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KbvErpBundleBuilderTest.class);

    KbvErpBundleBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Bundle for GKV with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void buildKbvBundleWithFixedValuesForGKV(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        String medicationRequestResourceId = "75ec9d5d-07ec-44cf-b841-d8a4ef20e521";
        String patientResourceId = "c9e9eeb8-e397-4d62-a977-656a18027f90";
        String practitionerResourceId = "d8ac97db-249d-4f14-8c9b-861f8b93ca76";
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        String insuranceResourceId = "914e46d1-95a2-44c7-b900-5ca4ee80b8d5";
        ErpWorkflowNamingSystem prescriptionIdSystem = kbvErpVersion.compareTo((Enum)KbvItaErpVersion.V1_0_2) == 0 ? ErpWorkflowNamingSystem.PRESCRIPTION_ID : ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        PrescriptionId prescriptionId = new PrescriptionId(prescriptionIdSystem, "160.100.000.000.011.09");
        KbvPractitioner prescribingPractitioner = ((KbvPractitionerBuilder)KbvPractitionerBuilder.builder().version(kbvForVersion).setId("d8ac97db-249d-4f14-8c9b-861f8b93ca76")).lanr("159753527").name("Mia", "Meyer", "Dr.").addQualification(QualificationType.DOCTOR_IN_TRAINING).addQualification("Super-Facharzt f\u00fcr alles M\u00f6gliche").build();
        KbvPractitioner responsiblePractitioner = ((KbvPractitionerBuilder)KbvPractitionerBuilder.builder().version(kbvForVersion).setId(UUID.randomUUID().toString())).lanr(BaseANR.randomFromQualification((QualificationType)QualificationType.DOCTOR).getValue()).name("Emmett", "Brown", "Dr.").addQualification(QualificationType.DOCTOR).addQualification("Super-Facharzt f\u00fcr alles M\u00f6gliche").build();
        KbvMedicalOrganization organization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(kbvForVersion).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Arztpraxis Meyer")).bsnr("757299999").phone("+490309876543")).email("info@praxis.de")).address("Berlin", "10623", "Wegelystra\u00dfe 3").build();
        KbvPatient patient = ((KbvPatientBuilder)KbvPatientBuilder.builder().version(kbvForVersion).setId("c9e9eeb8-e397-4d62-a977-656a18027f90")).kvnr(KVNR.random(), InsuranceTypeDe.GKV).name("Erwin", "Fleischer").birthDate("09.07.1973").address(Country.D, "Berlin", "10117", "Friedrichstra\u00dfe 136").build();
        KbvCoverage insurance = ((KbvCoverageBuilder)KbvCoverageBuilder.insurance((String)"101377508", (String)"Techniker-Krankenkasse").version(kbvForVersion).beneficiary(patient).setId("914e46d1-95a2-44c7-b900-5ca4ee80b8d5")).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).build();
        KbvErpMedication medication = ((KbvErpMedicationPZNBuilder)KbvErpMedicationPZNBuilder.builder().version(kbvErpVersion).setId("c1e7027e-3c5b-4e87-a10a-572676b92e22")).category(MedicationCategory.C_00).isVaccine(false).normgroesse(StandardSize.N1).darreichungsform(Darreichungsform.TKA).amount(5L, "Stk").pzn("04773414", "Doxycyclin AL 200 T, 10 Tabletten N1").build();
        KbvErpMedicationRequest medicationRequest = ((KbvErpMedicationRequestBuilder)KbvErpMedicationRequestBuilder.forPatient((KbvPatient)patient).version(kbvErpVersion).setId("75ec9d5d-07ec-44cf-b841-d8a4ef20e521")).insurance(insurance).requester(prescribingPractitioner).medication(medication).dosage("1-0-0-0").note("immer nur nach dem Essen").quantityPackages(20).status("active").intent("order").isBVG(false).hasEmergencyServiceFee(true).substitution(false).coPaymentStatus(StatusCoPayment.STATUS_0).build();
        KbvErpBundle kbvBundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((PrescriptionId)prescriptionId).version((ProfileVersion)kbvErpVersion)).practitioner(prescribingPractitioner)).attester(responsiblePractitioner)).medicalOrganization(organization)).patient(patient)).insurance(insurance)).statusKennzeichen("00")).medicationRequest(medicationRequest).medication((Medication)medication).build();
        Assertions.assertNotNull((Object)kbvBundle.getId());
        Assertions.assertEquals((Object)prescriptionId, (Object)kbvBundle.getPrescriptionId());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)InsuranceTypeDe.GKV, (Object)kbvBundle.getPatient().getInsuranceKind());
        Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssigner().isPresent());
        Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
        Assertions.assertEquals((Object)"1-0-0-0", (Object)kbvBundle.getMedicationRequest().getDosageInstructionFirstRep().getText());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Bundle for PKV with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void buildKbvBundleWithFixedValuesForPKV(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        String medicationRequestResourceId = "75ec9d5d-07ec-44cf-b841-d8a4ef20e521";
        String patientResourceId = "c9e9eeb8-e397-4d62-a977-656a18027f90";
        String practitionerResourceId = "d8ac97db-249d-4f14-8c9b-861f8b93ca76";
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        String insuranceResourceId = "914e46d1-95a2-44c7-b900-5ca4ee80b8d5";
        String prescriptionId = "160.100.000.000.011.09";
        KbvPractitioner practitioner = ((KbvPractitionerBuilder)KbvPractitionerBuilder.builder().version(kbvForVersion).setId("d8ac97db-249d-4f14-8c9b-861f8b93ca76")).zanr("159753527").name("Mia", "Meyer", "Dr.").addQualification(QualificationType.DENTIST).addQualification("Super-Facharzt f\u00fcr alles M\u00f6gliche").build();
        KbvMedicalOrganization medicalOrganization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(kbvForVersion).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Arztpraxis Meyer")).bsnr("757299999").phone("+490309876543")).email("info@praxis.de")).address(Country.D, "Berlin", "10623", "Wegelystra\u00dfe 3").build();
        AssignerOrganization assignerOrganization = ((KbvAssignerOrganizationBuilder)((KbvAssignerOrganizationBuilder)KbvAssignerOrganizationBuilder.builder().version(kbvForVersion).name("Bayerische Beamtenkrankenkasse")).iknr("168141347").phone("0301111111")).build();
        KbvPatient patient = ((KbvPatientBuilder)KbvPatientBuilder.builder().version(kbvForVersion).setId("c9e9eeb8-e397-4d62-a977-656a18027f90")).kvnr(KVNR.random(), InsuranceTypeDe.PKV).assigner((InstitutionalOrganization)assignerOrganization).name("Erwin", "Fleischer").birthDate("09.07.1973").address(Country.D, "Berlin", "10117", "Friedrichstra\u00dfe 136").build();
        KbvCoverage insurance = ((KbvCoverageBuilder)KbvCoverageBuilder.insurance((String)"101377508", (String)"Bayerische Beamtenkrankenkasse").version(kbvForVersion).beneficiary(patient).setId("914e46d1-95a2-44c7-b900-5ca4ee80b8d5")).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).build();
        KbvErpMedication medication = ((KbvErpMedicationPZNBuilder)KbvErpMedicationPZNBuilder.builder().version(kbvErpVersion).setId("c1e7027e-3c5b-4e87-a10a-572676b92e22")).category(MedicationCategory.C_00).isVaccine(false).normgroesse(StandardSize.N1).darreichungsform(Darreichungsform.TKA).amount(5L, "Stk").pzn("04773414", "Doxycyclin AL 200 T, 10 Tabletten N1").build();
        KbvErpMedicationRequest medicationRequest = ((KbvErpMedicationRequestBuilder)KbvErpMedicationRequestBuilder.forPatient((KbvPatient)patient).version(kbvErpVersion).setId("75ec9d5d-07ec-44cf-b841-d8a4ef20e521")).insurance(insurance).requester(practitioner).medication(medication).dosage("1-0-0-0").quantityPackages(20).status("active").intent("order").isBVG(false).mvo(MultiplePrescriptionExtension.asMultiple((int)1, (int)4).validForDays(360)).hasEmergencyServiceFee(true).substitution(false).coPaymentStatus(StatusCoPayment.STATUS_1).build();
        KbvErpBundle kbvBundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((String)"160.100.000.000.011.09").version((ProfileVersion)kbvErpVersion)).practitioner(practitioner)).medicalOrganization(medicalOrganization)).patient(patient)).insurance(insurance)).medicationRequest(medicationRequest).medication((Medication)medication).assigner((InstitutionalOrganization)assignerOrganization).build();
        Assertions.assertNotNull((Object)kbvBundle.getId());
        ErpWorkflowNamingSystem prescriptionIdSystem = kbvErpVersion.compareTo((Enum)KbvItaErpVersion.V1_0_2) == 0 ? ErpWorkflowNamingSystem.PRESCRIPTION_ID : ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        Assertions.assertEquals((Object)new PrescriptionId(prescriptionIdSystem, "160.100.000.000.011.09"), (Object)kbvBundle.getPrescriptionId());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)InsuranceTypeDe.PKV, (Object)kbvBundle.getPatient().getInsuranceKind());
        Assertions.assertTrue((boolean)kbvBundle.getPatient().getPkvAssigner().isPresent());
        if (kbvForVersion.compareTo((Enum)KbvItaForVersion.V1_1_0) < 0) {
            Assertions.assertTrue((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
        } else {
            Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
        }
    }

    @Test
    void buildKbvBundleWithFixedValuesAndNoAnrInPractitioner() {
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        String medicationRequestResourceId = "75ec9d5d-07ec-44cf-b841-d8a4ef20e521";
        String patientResourceId = "c9e9eeb8-e397-4d62-a977-656a18027f90";
        String practitionerResourceId = "d8ac97db-249d-4f14-8c9b-861f8b93ca76";
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        String insuranceResourceId = "914e46d1-95a2-44c7-b900-5ca4ee80b8d5";
        String prescriptionId = "160.100.000.000.011.09";
        KbvItaForVersion kbvForVersion = KbvItaForVersion.V1_1_0;
        KbvItaErpVersion kbvErpVersion = KbvItaErpVersion.V1_1_0;
        KbvPractitioner practitioner = ((KbvPractitionerBuilder)KbvPractitionerBuilder.builder().version(kbvForVersion).setId("d8ac97db-249d-4f14-8c9b-861f8b93ca76")).name("Mia", "Meyer", "Dr.").addQualification(QualificationType.DOCTOR_AS_REPLACEMENT).addQualification(AsvFachgruppennummer.from((String)"01")).addQualification("Super-Facharzt f\u00fcr alles M\u00f6gliche").build();
        KbvMedicalOrganization medicalOrganization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(kbvForVersion).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Arztpraxis Meyer")).bsnr("757299999").phone("+490309876543")).email("info@praxis.de")).address(Country.D, "Berlin", "10623", "Wegelystra\u00dfe 3").build();
        AssignerOrganization assignerOrganization = ((KbvAssignerOrganizationBuilder)((KbvAssignerOrganizationBuilder)KbvAssignerOrganizationBuilder.builder().version(kbvForVersion).name("Bayerische Beamtenkrankenkasse")).iknr("168141347").phone("0301111111")).build();
        KbvPatient patient = ((KbvPatientBuilder)KbvPatientBuilder.builder().version(kbvForVersion).setId("c9e9eeb8-e397-4d62-a977-656a18027f90")).kvnr(KVNR.random(), InsuranceTypeDe.PKV).assigner((InstitutionalOrganization)assignerOrganization).name("Erwin", "Fleischer").birthDate("09.07.1973").address(Country.D, "Berlin", "10117", "Friedrichstra\u00dfe 136").build();
        KbvCoverage insurance = ((KbvCoverageBuilder)KbvCoverageBuilder.insurance((String)"101377508", (String)"Bayerische Beamtenkrankenkasse").version(kbvForVersion).beneficiary(patient).setId("914e46d1-95a2-44c7-b900-5ca4ee80b8d5")).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).build();
        KbvErpMedication medication = ((KbvErpMedicationPZNBuilder)KbvErpMedicationPZNBuilder.builder().version(kbvErpVersion).setId("c1e7027e-3c5b-4e87-a10a-572676b92e22")).category(MedicationCategory.C_00).isVaccine(false).normgroesse(StandardSize.N1).darreichungsform(Darreichungsform.TKA).amount(5L, "Stk").pzn("04773414", "Doxycyclin AL 200 T, 10 Tabletten N1").build();
        KbvErpMedicationRequest medicationRequest = ((KbvErpMedicationRequestBuilder)KbvErpMedicationRequestBuilder.forPatient((KbvPatient)patient).version(kbvErpVersion).setId("75ec9d5d-07ec-44cf-b841-d8a4ef20e521")).insurance(insurance).requester(practitioner).medication(medication).dosage("1-0-0-0").quantityPackages(20).status("active").intent("order").isBVG(false).mvo(MultiplePrescriptionExtension.asMultiple((int)1, (int)4).validForDays(360)).hasEmergencyServiceFee(true).substitution(false).coPaymentStatus(StatusCoPayment.STATUS_1).build();
        KbvErpBundle kbvBundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((String)"160.100.000.000.011.09").version((ProfileVersion)kbvErpVersion)).statusKennzeichen(StatusKennzeichen.ASV)).practitioner(practitioner)).medicalOrganization(medicalOrganization)).patient(patient)).insurance(insurance)).medicationRequest(medicationRequest).medication((Medication)medication).assigner((InstitutionalOrganization)assignerOrganization).build();
        Assertions.assertNotNull((Object)kbvBundle.getId());
        ErpWorkflowNamingSystem prescriptionIdSystem = ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        Assertions.assertEquals((Object)new PrescriptionId(prescriptionIdSystem, "160.100.000.000.011.09"), (Object)kbvBundle.getPrescriptionId());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)InsuranceTypeDe.PKV, (Object)kbvBundle.getPatient().getInsuranceKind());
        Assertions.assertTrue((boolean)kbvBundle.getPatient().getPkvAssigner().isPresent());
        Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Bundle for BG with Accident at Work and with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void buildKbvBundleWithFixedValuesForBGWithAccidentAtWork(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        String medicationRequestResourceId = "75ec9d5d-07ec-44cf-b841-d8a4ef20e521";
        String patientResourceId = "c9e9eeb8-e397-4d62-a977-656a18027f90";
        String practitionerResourceId = "d8ac97db-249d-4f14-8c9b-861f8b93ca76";
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        String insuranceResourceId = "914e46d1-95a2-44c7-b900-5ca4ee80b8d5";
        String prescriptionId = "160.100.000.000.011.09";
        KbvPractitioner practitioner = ((KbvPractitionerBuilder)KbvPractitionerBuilder.builder().version(kbvForVersion).setId("d8ac97db-249d-4f14-8c9b-861f8b93ca76")).zanr("159753527").name("Mia", "Meyer", "Dr.").addQualification(QualificationType.DENTIST).addQualification("Super-Facharzt f\u00fcr alles M\u00f6gliche").build();
        KbvMedicalOrganization medicalOrganization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(kbvForVersion).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Arztpraxis Meyer")).bsnr("757299999").phone("+490309876543")).email("info@praxis.de")).address(Country.D, "Berlin", "10623", "Wegelystra\u00dfe 3").build();
        AssignerOrganization assignerOrganization = ((KbvAssignerOrganizationBuilder)((KbvAssignerOrganizationBuilder)KbvAssignerOrganizationBuilder.builder().version(kbvForVersion).name("Bayerische Beamtenkrankenkasse")).iknr("168141347").phone("0301111111")).build();
        KbvPatient patient = ((KbvPatientBuilder)KbvPatientBuilder.builder().version(kbvForVersion).setId("c9e9eeb8-e397-4d62-a977-656a18027f90")).kvnr(KVNR.random(), InsuranceTypeDe.PKV).assigner((InstitutionalOrganization)assignerOrganization).name("Erwin", "Fleischer").birthDate("09.07.1973").address(Country.D, "Berlin", "10117", "Friedrichstra\u00dfe 136").build();
        KbvCoverage insurance = ((KbvCoverageBuilder)KbvCoverageBuilder.insurance((String)"101377508", (String)"Bayerische Beamtenkrankenkasse").version(kbvForVersion).beneficiary(patient).versicherungsArt(InsuranceTypeDe.BG).setId("914e46d1-95a2-44c7-b900-5ca4ee80b8d5")).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).build();
        KbvErpMedication medication = ((KbvErpMedicationPZNBuilder)KbvErpMedicationPZNBuilder.builder().version(kbvErpVersion).setId("c1e7027e-3c5b-4e87-a10a-572676b92e22")).category(MedicationCategory.C_00).isVaccine(false).normgroesse(StandardSize.N1).darreichungsform(Darreichungsform.TKA).amount(5L, "Stk").pzn("04773414", "Doxycyclin AL 200 T, 10 Tabletten N1").build();
        KbvErpMedicationRequest medicationRequest = ((KbvErpMedicationRequestBuilder)KbvErpMedicationRequestBuilder.forPatient((KbvPatient)patient).version(kbvErpVersion).setId("75ec9d5d-07ec-44cf-b841-d8a4ef20e521")).insurance(insurance).requester(practitioner).medication(medication).accident(AccidentExtension.accidentAtWork().atWorkplace()).dosage("1-0-0-0").quantityPackages(20).status("active").intent("order").isBVG(false).mvo(MultiplePrescriptionExtension.asMultiple((int)1, (int)4).validForDays(360)).hasEmergencyServiceFee(true).substitution(false).coPaymentStatus(StatusCoPayment.STATUS_1).build();
        KbvErpBundle kbvBundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((String)"160.100.000.000.011.09").version((ProfileVersion)kbvErpVersion)).practitioner(practitioner)).medicalOrganization(medicalOrganization)).patient(patient)).insurance(insurance)).medicationRequest(medicationRequest).medication((Medication)medication).assigner((InstitutionalOrganization)assignerOrganization).build();
        Assertions.assertNotNull((Object)kbvBundle.getId());
        ErpWorkflowNamingSystem prescriptionIdSystem = kbvErpVersion.compareTo((Enum)KbvItaErpVersion.V1_0_2) == 0 ? ErpWorkflowNamingSystem.PRESCRIPTION_ID : ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        Assertions.assertEquals((Object)new PrescriptionId(prescriptionIdSystem, "160.100.000.000.011.09"), (Object)kbvBundle.getPrescriptionId());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)InsuranceTypeDe.PKV, (Object)kbvBundle.getPatient().getInsuranceKind());
        Assertions.assertEquals((Object)InsuranceTypeDe.BG, (Object)kbvBundle.getCoverage().getInsuranceKind());
        Assertions.assertTrue((boolean)kbvBundle.getPatient().getPkvAssigner().isPresent());
        if (kbvForVersion.compareTo((Enum)KbvItaForVersion.V1_1_0) < 0) {
            Assertions.assertTrue((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
        } else {
            Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
        }
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Bundle for PKV with Accident and with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void buildKbvBundleWithFixedValuesForPKVWithAccident(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        String medicationRequestResourceId = "75ec9d5d-07ec-44cf-b841-d8a4ef20e521";
        String patientResourceId = "c9e9eeb8-e397-4d62-a977-656a18027f90";
        String practitionerResourceId = "d8ac97db-249d-4f14-8c9b-861f8b93ca76";
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        String insuranceResourceId = "914e46d1-95a2-44c7-b900-5ca4ee80b8d5";
        String prescriptionId = "160.100.000.000.011.09";
        KbvPractitioner practitioner = ((KbvPractitionerBuilder)KbvPractitionerBuilder.builder().version(kbvForVersion).setId("d8ac97db-249d-4f14-8c9b-861f8b93ca76")).zanr("159753527").name("Mia", "Meyer", "Dr.").addQualification(QualificationType.DENTIST).addQualification("Super-Facharzt f\u00fcr alles M\u00f6gliche").build();
        KbvMedicalOrganization medicalOrganization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(kbvForVersion).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Arztpraxis Meyer")).bsnr("757299999").phone("+490309876543")).email("info@praxis.de")).address(Country.D, "Berlin", "10623", "Wegelystra\u00dfe 3").build();
        AssignerOrganization assignerOrganization = ((KbvAssignerOrganizationBuilder)((KbvAssignerOrganizationBuilder)KbvAssignerOrganizationBuilder.builder().version(kbvForVersion).name("Bayerische Beamtenkrankenkasse")).iknr("168141347").phone("0301111111")).build();
        KbvPatient patient = ((KbvPatientBuilder)KbvPatientBuilder.builder().version(kbvForVersion).setId("c9e9eeb8-e397-4d62-a977-656a18027f90")).kvnr(KVNR.random(), InsuranceTypeDe.PKV).assigner((InstitutionalOrganization)assignerOrganization).name("Erwin", "Fleischer").birthDate("09.07.1973").address(Country.D, "Berlin", "10117", "Friedrichstra\u00dfe 136").build();
        KbvCoverage insurance = ((KbvCoverageBuilder)KbvCoverageBuilder.insurance((String)"101377508", (String)"Bayerische Beamtenkrankenkasse").version(kbvForVersion).beneficiary(patient).versicherungsArt(InsuranceTypeDe.PKV).setId("914e46d1-95a2-44c7-b900-5ca4ee80b8d5")).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).build();
        KbvErpMedication medication = ((KbvErpMedicationPZNBuilder)KbvErpMedicationPZNBuilder.builder().version(kbvErpVersion).setId("c1e7027e-3c5b-4e87-a10a-572676b92e22")).category(MedicationCategory.C_00).isVaccine(false).normgroesse(StandardSize.N1).darreichungsform(Darreichungsform.TKA).amount(5L, "Stk").pzn("04773414", "Doxycyclin AL 200 T, 10 Tabletten N1").build();
        KbvErpMedicationRequest medicationRequest = ((KbvErpMedicationRequestBuilder)KbvErpMedicationRequestBuilder.forPatient((KbvPatient)patient).version(kbvErpVersion).setId("75ec9d5d-07ec-44cf-b841-d8a4ef20e521")).insurance(insurance).requester(practitioner).medication(medication).accident(AccidentExtension.accident()).dosage("1-0-0-0").quantityPackages(20).status("active").intent("order").isBVG(false).mvo(MultiplePrescriptionExtension.asMultiple((int)1, (int)4).validForDays(360)).hasEmergencyServiceFee(true).substitution(false).coPaymentStatus(StatusCoPayment.STATUS_1).build();
        KbvErpBundle kbvBundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((String)"160.100.000.000.011.09").version((ProfileVersion)kbvErpVersion)).practitioner(practitioner)).medicalOrganization(medicalOrganization)).patient(patient)).insurance(insurance)).medicationRequest(medicationRequest).medication((Medication)medication).assigner((InstitutionalOrganization)assignerOrganization).build();
        Assertions.assertNotNull((Object)kbvBundle.getId());
        ErpWorkflowNamingSystem prescriptionIdSystem = kbvErpVersion.compareTo((Enum)KbvItaErpVersion.V1_0_2) == 0 ? ErpWorkflowNamingSystem.PRESCRIPTION_ID : ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        Assertions.assertEquals((Object)new PrescriptionId(prescriptionIdSystem, "160.100.000.000.011.09"), (Object)kbvBundle.getPrescriptionId());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)InsuranceTypeDe.PKV, (Object)kbvBundle.getPatient().getInsuranceKind());
        Assertions.assertEquals((Object)InsuranceTypeDe.PKV, (Object)kbvBundle.getCoverage().getInsuranceKind());
        Assertions.assertTrue((boolean)kbvBundle.getPatient().getPkvAssigner().isPresent());
        if (kbvForVersion.compareTo((Enum)KbvItaForVersion.V1_1_0) < 0) {
            Assertions.assertTrue((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
        } else {
            Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
        }
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Bundle for PKV with Accident at Work and invalid Coverage Type with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void buildKbvBundleForPKVWithAccidentAndInvalidCoverage(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        String prescriptionId = "160.100.000.000.011.09";
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withVersion(kbvForVersion).fake();
        KbvMedicalOrganizationFaker medicalOrgBuilder = kbvForVersion.compareTo((Enum)KbvItaForVersion.V1_1_0) < 0 ? KbvMedicalOrganizationFaker.medicalPractice() : KbvMedicalOrganizationFaker.builder();
        KbvMedicalOrganization medicalOrganization = medicalOrgBuilder.withVersion(kbvForVersion).fake();
        AssignerOrganization assignerOrganization = KbvAssignerOrganizationFaker.builder().withVersion(kbvForVersion).fake();
        KbvPatient patient = KbvPatientFaker.builder().withKvnrAndInsuranceType(KVNR.random(), InsuranceTypeDe.PKV).withVersion(kbvForVersion).withAssignerRef((InstitutionalOrganization)assignerOrganization).fake();
        KbvCoverage insurance = KbvCoverageFaker.builder().withInsuranceType(InsuranceTypeDe.PKV).withVersion(kbvForVersion).withBeneficiary(patient).fake();
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withVersion(kbvErpVersion).fake();
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withPatient(patient).withVersion(kbvErpVersion).withInsurance(insurance).withRequester(practitioner).withMedication(medication).withAccident(AccidentExtension.accidentAtWork().atWorkplace()).fake();
        KbvErpBundle kbvBundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((String)"160.100.000.000.011.09").version((ProfileVersion)kbvErpVersion)).practitioner(practitioner)).medicalOrganization(medicalOrganization)).patient(patient)).insurance(insurance)).medicationRequest(medicationRequest).medication((Medication)medication).assigner((InstitutionalOrganization)assignerOrganization).build();
        if (kbvForVersion.compareTo((Enum)KbvItaForVersion.V1_1_0) < 0) {
            ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
            Assertions.assertTrue((boolean)result.isSuccessful());
        } else {
            ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
            Assertions.assertFalse((boolean)result.isSuccessful());
        }
    }

    @ParameterizedTest(name="[{index}] -> Build faked KBV Bundle with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void buildKbvBundleWithFaker(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        for (int i = 0; i < 5; ++i) {
            KbvPractitioner practitioner = KbvPractitionerFaker.builder().withVersion(kbvForVersion).fake();
            KbvMedicalOrganization medicalOrganization = KbvMedicalOrganizationFaker.medicalPractice().withVersion(kbvForVersion).fake();
            AssignerOrganization assignerOrganization = KbvAssignerOrganizationFaker.builder().withVersion(kbvForVersion).fake();
            KbvPatient patient = KbvPatientFaker.builder().withAssignerRef((InstitutionalOrganization)assignerOrganization).withVersion(kbvForVersion).fake();
            KbvCoverage insurance = KbvCoverageFaker.builder().withBeneficiary(patient).withVersion(kbvForVersion).fake();
            KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withVersion(kbvErpVersion).fake();
            KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().withVersion(kbvErpVersion, kbvForVersion).withPractitioner(practitioner).withCustodian(medicalOrganization).withAssignerOrganization((InstitutionalOrganization)assignerOrganization).withPatient(patient).withInsurance(insurance, patient).withMedication(medication).fake();
            log.trace("Validating Faker KBV-Bundle with ID {}", (Object)kbvBundle.getPrescriptionId());
            Assertions.assertTrue((boolean)this.logIfInvalid((Resource)kbvBundle));
        }
    }

    @ParameterizedTest(name="[{index}] -> Build faked KBV Bundle with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    @ClearSystemProperty.ClearSystemProperties(value={@ClearSystemProperty(key="kbv.ita.for"), @ClearSystemProperty(key="kbv.ita.erp")})
    void buildKbvBundleWithSuperFaker(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        System.setProperty(kbvErpVersion.getName(), kbvErpVersion.getVersion());
        System.setProperty(kbvForVersion.getName(), kbvForVersion.getVersion());
        for (int i = 0; i < 5; ++i) {
            KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().withKvnr(KVNR.random()).withPznAndMedicationName(PZN.from((String)"04773414"), GemFaker.fakerDrugName()).fake();
            log.trace("Validating Faker KBV-Bundle {} with ID {}", (Object)kbvBundle.getMetaProfileVersion(), (Object)kbvBundle.getPrescriptionId());
            Assertions.assertTrue((boolean)this.logIfInvalid((Resource)kbvBundle));
        }
    }

    @ParameterizedTest(name="[{index}] -> Build faked KBV Bundle with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    @ClearSystemProperty.ClearSystemProperties(value={@ClearSystemProperty(key="kbv.ita.for"), @ClearSystemProperty(key="kbv.ita.erp")})
    void buildKbvBundleWithSuperFaker02(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        System.setProperty(kbvErpVersion.getName(), kbvErpVersion.getVersion());
        System.setProperty(kbvForVersion.getName(), kbvForVersion.getVersion());
        for (int i = 0; i < 1; ++i) {
            KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().withKvnr(KVNR.random()).fake();
            log.trace("Validating Faker KBV-Bundle {} with ID {}", (Object)kbvBundle.getMetaProfileVersion(), (Object)kbvBundle.getPrescriptionId());
            Assertions.assertTrue((boolean)this.logIfInvalid((Resource)kbvBundle));
        }
    }

    @ParameterizedTest(name="[{index}] -> Build faked KBV Bundle with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    @ClearSystemProperty.ClearSystemProperties(value={@ClearSystemProperty(key="kbv.ita.for"), @ClearSystemProperty(key="kbv.ita.erp")})
    void buildKbvBundleWithSuperFaker03(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        System.setProperty(kbvErpVersion.getName(), kbvErpVersion.getVersion());
        System.setProperty(kbvForVersion.getName(), kbvForVersion.getVersion());
        for (int i = 0; i < 5; ++i) {
            KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().withKvnr(KVNR.random()).withPrescriptionId(new PrescriptionId("160.002.362.150.600.45")).fake();
            log.trace("Validating Faker KBV-Bundle {} with ID {}", (Object)kbvBundle.getMetaProfileVersion(), (Object)kbvBundle.getPrescriptionId());
            Assertions.assertTrue((boolean)this.logIfInvalid((Resource)kbvBundle));
        }
    }

    private boolean logIfInvalid(Resource resource) {
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, resource);
        if (result.isSuccessful()) {
            return true;
        }
        ValidatorUtil.encodeAndValidate(parser, resource, EncodingType.XML, true, true);
        return false;
    }

    @ParameterizedTest(name="[{index}] -> Change authoredOn Date in faked KBV Bundle with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    @ClearSystemProperty.ClearSystemProperties(value={@ClearSystemProperty(key="kbv.ita.for"), @ClearSystemProperty(key="kbv.ita.erp")})
    void buildAndChangeAuthoredOnDate(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        System.setProperty(kbvErpVersion.getName(), kbvErpVersion.getVersion());
        System.setProperty(kbvForVersion.getName(), kbvForVersion.getVersion());
        Date authoredOn = Date.from(Instant.now().minus(2L, ChronoUnit.DAYS));
        KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().withKvnr(KVNR.random()).withAuthorDate(authoredOn).withPrescriptionId(new PrescriptionId("160.002.362.150.600.45")).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        LocalDate expected = authoredOn.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate actual = kbvBundle.getAuthoredOn().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @ParameterizedTest(name="[{index}] -> Build incomplete KBV Bundle with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaErpVersions"})
    void shouldThrowOnEmptyKbvBundleBuilder(KbvItaErpVersion kbvErpVersion) {
        KbvErpBundleBuilder kb = (KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((PrescriptionId)PrescriptionId.random()).version((ProfileVersion)kbvErpVersion);
        Assertions.assertThrows(BuilderException.class, () -> ((KbvErpBundleBuilder)kb).build());
    }

    @ParameterizedTest(name="[{index}] -> Build incomplete KBV Bundle with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void buildFakerWithGivenMedicationCategory(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withVersion(kbvErpVersion).withCategory(MedicationCategory.C_00).fake();
        KbvCoverage coverage = KbvCoverageFaker.builder().withInsuranceType(InsuranceTypeDe.GKV).withVersion(kbvForVersion).fake();
        KbvPatient patient = KbvPatientFaker.builder().withKvnrAndInsuranceType(KVNR.random(), InsuranceTypeDe.GKV).withVersion(kbvForVersion).fake();
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withVersion(kbvForVersion).fake();
        KbvMedicalOrganization custodian = KbvMedicalOrganizationFaker.medicalPractice().withVersion(kbvForVersion).fake();
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asNonMultiple();
        KbvErpBundleBuilder kbvBundleBuilder = ((KbvErpBundleBuilder)KbvErpBundleBuilder.builder().version((ProfileVersion)kbvErpVersion)).medication((Medication)medication).medicationRequest(KbvErpMedicationRequestFaker.builder().withPatient(patient).withVersion(kbvErpVersion).withMedication(medication).withMvo(mvo).withInsurance(coverage).withRequester(practitioner).fake());
        ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)kbvBundleBuilder.insurance(coverage)).patient(patient)).practitioner(practitioner)).medicalOrganization(custodian)).prescriptionId(PrescriptionId.random());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundleBuilder.build());
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Get Practitioner from KBV Bundle with versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void shouldGetPractitionersFromKbvBundle(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        List<QualificationType> qualificationTypes = List.of(QualificationType.DOCTOR, QualificationType.DENTIST);
        qualificationTypes.forEach(qt -> {
            KbvPractitioner practitioner = KbvPractitionerFaker.builder().withVersion(kbvForVersion).withAnr(BaseANR.randomFromQualification((QualificationType)qt)).fake();
            KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().withKvnr(KVNR.random()).withVersion(kbvErpVersion, kbvForVersion).withPractitioner(practitioner).fake();
            KbvPractitioner actual = kbvBundle.getPractitioner();
            Assertions.assertEquals((Object)practitioner.getANRType(), (Object)actual.getANRType());
        });
    }

    @Test
    void shouldBuildBundleWithSupplyRequestCorrect() {
        KbvItaForVersion kbvForVersion = KbvItaForVersion.V1_1_0;
        KbvItaErpVersion kbvErpVersion = KbvItaErpVersion.V1_1_0;
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        String patientResourceId = "c9e9eeb8-e397-4d62-a977-656a18027f90";
        String practitionerResourceId = "d8ac97db-249d-4f14-8c9b-861f8b93ca76";
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        String insuranceResourceId = "914e46d1-95a2-44c7-b900-5ca4ee80b8d5";
        ErpWorkflowNamingSystem prescriptionIdSystem = ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        PrescriptionId prescriptionId = new PrescriptionId(prescriptionIdSystem, "160.100.000.000.011.09");
        KbvPractitioner practitioner = ((KbvPractitionerBuilder)KbvPractitionerBuilder.builder().version(kbvForVersion).setId("d8ac97db-249d-4f14-8c9b-861f8b93ca76")).lanr("159753527").name("Mia", "Meyer", "Dr.").addQualification(QualificationType.DOCTOR).addQualification("Super-Facharzt f\u00fcr alles M\u00f6gliche").build();
        KbvMedicalOrganization organization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(kbvForVersion).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Arztpraxis Meyer")).bsnr("757299999").phone("+490309876543")).email("info@praxis.de")).address("Berlin", "10623", "Wegelystra\u00dfe 3").build();
        KbvPatient patient = ((KbvPatientBuilder)KbvPatientBuilder.builder().version(kbvForVersion).setId("c9e9eeb8-e397-4d62-a977-656a18027f90")).kvnr(KVNR.random(), InsuranceTypeDe.GKV).name("Erwin", "Fleischer").birthDate("09.07.1973").address(Country.D, "Berlin", "10117", "Friedrichstra\u00dfe 136").build();
        KbvCoverage insurance = ((KbvCoverageBuilder)KbvCoverageBuilder.insurance((String)"101377508", (String)"Techniker-Krankenkasse").version(kbvForVersion).beneficiary(patient).setId("914e46d1-95a2-44c7-b900-5ca4ee80b8d5")).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).build();
        KbvErpMedication medication = ((KbvErpMedicationPZNBuilder)KbvErpMedicationPZNBuilder.builder().version(kbvErpVersion).setId("c1e7027e-3c5b-4e87-a10a-572676b92e22")).category(MedicationCategory.C_00).isVaccine(false).normgroesse(StandardSize.N1).darreichungsform(Darreichungsform.TKA).amount(5L, "Stk").pzn("04773414", "Doxycyclin AL 200 T, 10 Tabletten N1").build();
        SupplyRequest supplyRequest = SupplyRequestBuilder.withCoverage((KbvCoverage)insurance).requester(practitioner).medication(medication).build();
        KbvErpBundle kbvBundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((PrescriptionId)prescriptionId).version((ProfileVersion)kbvErpVersion)).practitioner(practitioner)).medicalOrganization(organization)).patient(patient)).insurance(insurance)).statusKennzeichen("00")).supplyRequest(supplyRequest).medication((Medication)medication).build();
        Assertions.assertNotNull((Object)kbvBundle.getId());
        Assertions.assertEquals((Object)prescriptionId, (Object)kbvBundle.getPrescriptionId());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)InsuranceTypeDe.GKV, (Object)kbvBundle.getPatient().getInsuranceKind());
        Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssigner().isPresent());
        Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
    }

    @Test
    void shouldBuildInvalidBundleWithSupplyRequestAndMedicationRequest() {
        KbvItaForVersion kbvForVersion = KbvItaForVersion.V1_1_0;
        KbvItaErpVersion kbvErpVersion = KbvItaErpVersion.V1_1_0;
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        String medicationRequestResourceId = "75ec9d5d-07ec-44cf-b841-d8a4ef20e521";
        String supplyRequestResourceId = UUID.randomUUID().toString();
        String patientResourceId = "c9e9eeb8-e397-4d62-a977-656a18027f90";
        String practitionerResourceId = "d8ac97db-249d-4f14-8c9b-861f8b93ca76";
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        String insuranceResourceId = "914e46d1-95a2-44c7-b900-5ca4ee80b8d5";
        ErpWorkflowNamingSystem prescriptionIdSystem = ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        PrescriptionId prescriptionId = new PrescriptionId(prescriptionIdSystem, "160.100.000.000.011.09");
        KbvPractitioner practitioner = ((KbvPractitionerBuilder)KbvPractitionerBuilder.builder().version(kbvForVersion).setId("d8ac97db-249d-4f14-8c9b-861f8b93ca76")).lanr("159753527").name("Mia", "Meyer", "Dr.").addQualification(QualificationType.DOCTOR).addQualification("Super-Facharzt f\u00fcr alles M\u00f6gliche").build();
        KbvMedicalOrganization organization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(kbvForVersion).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Arztpraxis Meyer")).bsnr("757299999").phone("+490309876543")).email("info@praxis.de")).address("Berlin", "10623", "Wegelystra\u00dfe 3").build();
        KbvPatient patient = ((KbvPatientBuilder)KbvPatientBuilder.builder().version(kbvForVersion).setId("c9e9eeb8-e397-4d62-a977-656a18027f90")).kvnr(KVNR.random(), InsuranceTypeDe.GKV).name("Erwin", "Fleischer").birthDate("09.07.1973").address(Country.D, "Berlin", "10117", "Friedrichstra\u00dfe 136").build();
        KbvCoverage insurance = ((KbvCoverageBuilder)KbvCoverageBuilder.insurance((String)"101377508", (String)"Techniker-Krankenkasse").version(kbvForVersion).beneficiary(patient).setId("914e46d1-95a2-44c7-b900-5ca4ee80b8d5")).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).build();
        KbvErpMedication medication = ((KbvErpMedicationPZNBuilder)KbvErpMedicationPZNBuilder.builder().version(kbvErpVersion).setId("c1e7027e-3c5b-4e87-a10a-572676b92e22")).category(MedicationCategory.C_00).isVaccine(false).normgroesse(StandardSize.N1).darreichungsform(Darreichungsform.TKA).amount(5L, "Stk").pzn("04773414", "Doxycyclin AL 200 T, 10 Tabletten N1").build();
        KbvErpMedicationRequest medicationRequest = ((KbvErpMedicationRequestBuilder)KbvErpMedicationRequestBuilder.forPatient((KbvPatient)patient).version(kbvErpVersion).setId("75ec9d5d-07ec-44cf-b841-d8a4ef20e521")).insurance(insurance).requester(practitioner).medication(medication).dosage("1-0-0-0").quantityPackages(20).status("active").intent("order").isBVG(false).hasEmergencyServiceFee(true).substitution(false).coPaymentStatus(StatusCoPayment.STATUS_0).build();
        SupplyRequest supplyRequest = ((SupplyRequestBuilder)SupplyRequestBuilder.withCoverage((KbvCoverage)insurance).setId(supplyRequestResourceId)).requester(practitioner).medication(medication).build();
        KbvErpBundle kbvBundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((PrescriptionId)prescriptionId).version((ProfileVersion)kbvErpVersion)).practitioner(practitioner)).medicalOrganization(organization)).patient(patient)).insurance(insurance)).statusKennzeichen("00")).medicationRequest(medicationRequest).supplyRequest(supplyRequest).medication((Medication)medication).build();
        Assertions.assertNotNull((Object)kbvBundle.getId());
        Assertions.assertEquals((Object)prescriptionId, (Object)kbvBundle.getPrescriptionId());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
        Assertions.assertFalse((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)InsuranceTypeDe.GKV, (Object)kbvBundle.getPatient().getInsuranceKind());
        Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssigner().isPresent());
        Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
        Assertions.assertEquals((Object)supplyRequestResourceId, (Object)((Bundle.BundleEntryComponent)kbvBundle.getEntry().get(7)).getResource().getId());
    }

    @ParameterizedTest(name="[{index}] -> Build incomplete KBV Bundle with MedicationCompounding and versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void buildFakerWithGivenMedicationCompounding(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        String medicationResourceId = "c1e7027e-3c5b-4e87-a10a-572676b92e22";
        String medicationRequestResourceId = "75ec9d5d-07ec-44cf-b841-d8a4ef20e521";
        String patientResourceId = "c9e9eeb8-e397-4d62-a977-656a18027f90";
        String practitionerResourceId = "d8ac97db-249d-4f14-8c9b-861f8b93ca76";
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        String insuranceResourceId = "914e46d1-95a2-44c7-b900-5ca4ee80b8d5";
        ErpWorkflowNamingSystem prescriptionIdSystem = kbvErpVersion.compareTo((Enum)KbvItaErpVersion.V1_0_2) == 0 ? ErpWorkflowNamingSystem.PRESCRIPTION_ID : ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        PrescriptionId prescriptionId = new PrescriptionId(prescriptionIdSystem, "160.100.000.000.011.09");
        KbvPractitioner practitioner = ((KbvPractitionerBuilder)KbvPractitionerBuilder.builder().version(kbvForVersion).setId("d8ac97db-249d-4f14-8c9b-861f8b93ca76")).lanr("159753527").name("Mia", "Meyer", "Dr.").addQualification(QualificationType.DOCTOR).addQualification("Super-Facharzt f\u00fcr alles M\u00f6gliche").build();
        KbvMedicalOrganization organization = ((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)((KbvMedicalOrganizationBuilder)KbvMedicalOrganizationBuilder.builder().version(kbvForVersion).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Arztpraxis Meyer")).bsnr("757299999").phone("+490309876543")).email("info@praxis.de")).address("Berlin", "10623", "Wegelystra\u00dfe 3").build();
        KbvPatient patient = ((KbvPatientBuilder)KbvPatientBuilder.builder().version(kbvForVersion).setId("c9e9eeb8-e397-4d62-a977-656a18027f90")).kvnr(KVNR.random(), InsuranceTypeDe.GKV).name("Erwin", "Fleischer").birthDate("09.07.1973").address(Country.D, "Berlin", "10117", "Friedrichstra\u00dfe 136").build();
        KbvCoverage insurance = ((KbvCoverageBuilder)KbvCoverageBuilder.insurance((String)"101377508", (String)"Techniker-Krankenkasse").version(kbvForVersion).beneficiary(patient).setId("914e46d1-95a2-44c7-b900-5ca4ee80b8d5")).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).build();
        KbvErpMedication medication = KbvErpMedicationCompoundingFaker.builder().withMedicationIngredient(PZN.random(), "nameOfMedicine", "freetext").withResourceId("c1e7027e-3c5b-4e87-a10a-572676b92e22").withVersion(kbvErpVersion).withCategory(MedicationCategory.C_00).fake();
        KbvErpMedicationRequest medicationRequest = ((KbvErpMedicationRequestBuilder)KbvErpMedicationRequestBuilder.forPatient((KbvPatient)patient).version(kbvErpVersion).setId("75ec9d5d-07ec-44cf-b841-d8a4ef20e521")).insurance(insurance).requester(practitioner).medication(medication).dosage("im schleim baden!").note("immer nur nach dem Essen").quantityPackages(20).status("active").intent("order").isBVG(false).hasEmergencyServiceFee(true).substitution(false).coPaymentStatus(StatusCoPayment.STATUS_0).build();
        KbvErpBundle kbvBundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((PrescriptionId)prescriptionId).version((ProfileVersion)kbvErpVersion)).practitioner(practitioner)).medicalOrganization(organization)).patient(patient)).insurance(insurance)).statusKennzeichen("00")).medicationRequest(medicationRequest).medication((Medication)medication).build();
        Assertions.assertNotNull((Object)kbvBundle.getId());
        Assertions.assertEquals((Object)prescriptionId, (Object)kbvBundle.getPrescriptionId());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle, EncodingType.XML);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)InsuranceTypeDe.GKV, (Object)kbvBundle.getPatient().getInsuranceKind());
        Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssigner().isPresent());
        Assertions.assertFalse((boolean)kbvBundle.getPatient().getPkvAssignerName().isPresent());
    }

    @ParameterizedTest(name="[{index}] -> Build incomplete KBV Bundle with MedicationCompounding and versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void fakerShouldWorkWithMedicationCompounding(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        KbvErpMedication medication = KbvErpMedicationCompoundingFaker.builder().withVersion(kbvErpVersion).fake();
        AssignerOrganization assigner = KbvAssignerOrganizationFaker.builder().withVersion(kbvForVersion).fake();
        KbvPatient patient = KbvPatientFaker.builder().withVersion(kbvForVersion).withAssignerRef((InstitutionalOrganization)assigner).fake();
        KbvCoverage insurance = KbvCoverageFaker.builder().withInsuranceType(patient.getInsuranceKind()).withVersion(kbvForVersion).fake();
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withVersion(kbvForVersion).fake();
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withPatient(patient).withMedication(medication).withRequester(practitioner).withInsurance(insurance).withVersion(kbvErpVersion).fake();
        KbvMedicalOrganization organisation = KbvMedicalOrganizationFaker.medicalPractice().withVersion(kbvForVersion).fake();
        KbvErpBundle bundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((PrescriptionId)PrescriptionId.random()).patient(patient)).version((ProfileVersion)kbvErpVersion)).assigner((InstitutionalOrganization)assigner).practitioner(practitioner)).medicalOrganization(organisation)).medicationRequest(medicationRequest).insurance(insurance)).medication((Medication)medication).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build incomplete KBV Bundle with MedicationFreeText and versions KbvItaForVersion {0} and KbvItaErpVersion {1}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvBundleVersions"})
    void fakerShouldWorkWithMedicationFreeText(KbvItaForVersion kbvForVersion, KbvItaErpVersion kbvErpVersion) {
        KbvErpMedication medication = KbvErpMedicationFreeTextFaker.builder().withVersion(kbvErpVersion).fake();
        AssignerOrganization assigner = KbvAssignerOrganizationFaker.builder().withVersion(kbvForVersion).fake();
        KbvPatient patient = KbvPatientFaker.builder().withVersion(kbvForVersion).withAssignerRef((InstitutionalOrganization)assigner).fake();
        KbvCoverage insurance = KbvCoverageFaker.builder().withInsuranceType(patient.getInsuranceKind()).withVersion(kbvForVersion).fake();
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withVersion(kbvForVersion).fake();
        KbvErpMedicationRequest medicationRequest = KbvErpMedicationRequestFaker.builder().withPatient(patient).withMedication(medication).withRequester(practitioner).withInsurance(insurance).withVersion(kbvErpVersion).fake();
        KbvMedicalOrganization organisation = KbvMedicalOrganizationFaker.medicalPractice().withVersion(kbvForVersion).fake();
        KbvErpBundle bundle = ((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)((KbvErpBundleBuilder)KbvErpBundleBuilder.forPrescription((PrescriptionId)PrescriptionId.random()).patient(patient)).version((ProfileVersion)kbvErpVersion)).assigner((InstitutionalOrganization)assigner).practitioner(practitioner)).medicalOrganization(organisation)).medicationRequest(medicationRequest).insurance(insurance)).medication((Medication)medication).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

