/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.r4.kbv.KbvCoverage;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.DmpKennzeichen;
import de.gematik.test.erezept.fhir.valuesets.PersonGroup;
import de.gematik.test.erezept.fhir.valuesets.VersichertenStatus;
import de.gematik.test.erezept.fhir.valuesets.Wop;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvCoverageFakerTest
extends ErpFhirParsingTest {
    KbvCoverageFakerTest() {
    }

    @Test
    void buildFakeKbvCoverageWithPersonGroup() {
        KbvCoverage coverage = KbvCoverageFaker.builder().withPersonGroup((PersonGroup)GemFaker.fakerValueSet(PersonGroup.class)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvCoverageWithDmpKennzeichen() {
        KbvCoverage coverage = KbvCoverageFaker.builder().withDmpKennzeichen(DmpKennzeichen.DM1).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvCoverageWithWop() {
        KbvCoverage coverage = KbvCoverageFaker.builder().withWop((Wop)GemFaker.fakerValueSet(Wop.class)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvCoverageWithInsuranceStatus() {
        KbvCoverage coverage = KbvCoverageFaker.builder().withInsuranceStatus((VersichertenStatus)GemFaker.fakerValueSet(VersichertenStatus.class)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvCoverageWithBeneficiary() {
        KbvPatient patient = KbvPatientFaker.builder().fake();
        KbvCoverage coverage = KbvCoverageFaker.builder().withBeneficiary(patient).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeKbvCoverageWithInsuranceType() {
        KbvCoverage coverage = KbvCoverageFaker.builder().withInsuranceType((InsuranceTypeDe)GemFaker.randomElement((Object[])new InsuranceTypeDe[]{InsuranceTypeDe.PKV, InsuranceTypeDe.GKV})).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

