/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.IKNR;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvCoverage;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.GkvInsuranceCoverageInfo;
import de.gematik.test.erezept.fhir.values.InsuranceCoverageInfo;
import de.gematik.test.erezept.fhir.valuesets.DmpKennzeichen;
import de.gematik.test.erezept.fhir.valuesets.PayorType;
import de.gematik.test.erezept.fhir.valuesets.PersonGroup;
import de.gematik.test.erezept.fhir.valuesets.VersichertenStatus;
import de.gematik.test.erezept.fhir.valuesets.Wop;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KbvCoverageBuilderTest
extends ErpFhirParsingTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KbvCoverageBuilderTest.class);

    KbvCoverageBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build KBV GKV Coverage with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildCoverageWithFixedValues(KbvItaForVersion version) {
        KbvPatient patient = KbvPatientFaker.builder().withVersion(version).withInsuranceType(InsuranceTypeDe.GKV).fake();
        KbvCoverage coverage = KbvCoverageBuilder.insurance((InsuranceCoverageInfo)GkvInsuranceCoverageInfo.TK).version(version).beneficiary(patient).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)patient.getInsuranceKind(), (Object)coverage.getInsuranceKind());
        Assertions.assertEquals((Object)"101575519", (Object)coverage.getIknr().getValue());
        Assertions.assertEquals((Object)"Techniker Krankenkasse", (Object)coverage.getName());
        Assertions.assertNotNull((Object)coverage.getDescription());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Coverage with UK PayorType with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildCoverageWithUKPayorType(KbvItaForVersion version) {
        KbvPatient patient = KbvPatientFaker.builder().withVersion(version).fake();
        GkvInsuranceCoverageInfo tkCoverageInfo = GkvInsuranceCoverageInfo.TK;
        KbvCoverage coverage = KbvCoverageBuilder.insurance((InsuranceCoverageInfo)tkCoverageInfo).version(version).beneficiary(patient).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).versicherungsArt(PayorType.UK).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)tkCoverageInfo.getIknr(), (Object)coverage.getIknr().getValue());
        Assertions.assertTrue((boolean)coverage.getAlternativeIknr().isPresent());
        Assertions.assertEquals((Object)"121191241", (Object)((IKNR)coverage.getAlternativeIknr().get()).getValue());
        Assertions.assertEquals((Object)tkCoverageInfo.getName(), (Object)coverage.getName());
        Assertions.assertNotNull((Object)coverage.getDescription());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV Coverage with SKT PayorType with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildCoverageWithSKTPayorType(KbvItaForVersion version) {
        KbvPatient patient = KbvPatientFaker.builder().withVersion(version).fake();
        GkvInsuranceCoverageInfo tkCoverageInfo = GkvInsuranceCoverageInfo.TK;
        KbvCoverage coverage = KbvCoverageBuilder.insurance((InsuranceCoverageInfo)tkCoverageInfo).version(version).beneficiary(patient).personGroup(PersonGroup.NOT_SET).dmpKennzeichen(DmpKennzeichen.ASTHMA).wop(Wop.BERLIN).versichertenStatus(VersichertenStatus.PENSIONER).versicherungsArt(PayorType.SKT).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)tkCoverageInfo.getIknr(), (Object)coverage.getIknr().getValue());
        Assertions.assertFalse((boolean)coverage.getAlternativeIknr().isPresent());
        Assertions.assertEquals((Object)tkCoverageInfo.getName(), (Object)coverage.getName());
        Assertions.assertNotNull((Object)coverage.getDescription());
    }

    @ParameterizedTest(name="[{index}] -> Build faker KBV Coverage with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildCoverageWithFaker01(KbvItaForVersion version) {
        for (int i = 0; i < 2; ++i) {
            KbvCoverage coverage = KbvCoverageFaker.builder().withVersion(version).fake();
            ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
            Assertions.assertTrue((boolean)result.isSuccessful());
        }
    }

    @ParameterizedTest(name="[{index}] -> Build faker KBV Coverage for GKV/PKV/BG/BEI with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildCoverageWithFaker02(KbvItaForVersion version) {
        List<InsuranceTypeDe> insuranceKinds = List.of(InsuranceTypeDe.GKV, InsuranceTypeDe.PKV, InsuranceTypeDe.BG);
        insuranceKinds.forEach(ik -> {
            for (int i = 0; i < 2; ++i) {
                KbvCoverage coverage = KbvCoverageFaker.builder().withInsuranceType(ik).withVersion(version).fake();
                log.trace("Validating Faker Coverage with ID {}", (Object)coverage.getId());
                ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)coverage);
                Assertions.assertTrue((boolean)result.isSuccessful());
            }
        });
    }
}

