/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.IKNR;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvAssignerOrganizationFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import de.gematik.test.erezept.fhir.r4.kbv.AssignerOrganization;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvAssignerOrganizationFakerTest
extends ErpFhirParsingTest {
    KbvAssignerOrganizationFakerTest() {
    }

    @Test
    void buildFakerAssignerOrganizationWithVersion() {
        AssignerOrganization fakeOrganization = KbvAssignerOrganizationFaker.builder().withVersion(KbvItaForVersion.getDefaultVersion()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)fakeOrganization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerAssignerOrganizationWithAddress() {
        AssignerOrganization fakeOrganization = KbvAssignerOrganizationFaker.builder().withAddress(GemFaker.fakerCity(), GemFaker.fakerZipCode(), GemFaker.fakerStreetName()).fake();
        AssignerOrganization fakeOrganization2 = KbvAssignerOrganizationFaker.builder().withAddress(GemFaker.fakerCountry(), GemFaker.fakerCity(), GemFaker.fakerZipCode(), GemFaker.fakerStreetName()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)fakeOrganization);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)fakeOrganization2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakerAssignerOrganizationWithIknr() {
        IKNR iknr = IKNR.random();
        AssignerOrganization fakeOrganization = KbvAssignerOrganizationFaker.builder().withIknr(iknr).fake();
        AssignerOrganization fakeOrganization2 = KbvAssignerOrganizationFaker.builder().withIknr((String)iknr.getValue()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)fakeOrganization);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)fakeOrganization2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakerAssignerOrganizationWithPhone() {
        AssignerOrganization fakerOrganization = KbvAssignerOrganizationFaker.builder().withPhone(GemFaker.fakerPhone()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)fakerOrganization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

