/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.de.value.IKNR;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.test.erezept.fhir.builder.kbv.KbvAssignerOrganizationBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvAssignerOrganizationFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import de.gematik.test.erezept.fhir.r4.kbv.AssignerOrganization;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import java.util.Optional;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class KbvAssignerOrganizationBuilderTest
extends ErpFhirParsingTest {
    KbvAssignerOrganizationBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build KBV GKV Patient with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildAssignerOrganizationWithFixedValues(KbvItaForVersion version) {
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        AssignerOrganization organization = ((KbvAssignerOrganizationBuilder)((KbvAssignerOrganizationBuilder)((KbvAssignerOrganizationBuilder)((KbvAssignerOrganizationBuilder)KbvAssignerOrganizationBuilder.builder().version(version).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Arztpraxis Meyer")).iknr(IKNR.asSidIknr((String)"757299999")).phone("+490309876543")).email("info@praxis.de")).address("Berlin", "10623", "Wegelystra\u00dfe 3").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV GKV Patient with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildAssignerOrganizationWithFaker02(KbvItaForVersion version) {
        AssignerOrganization organization = KbvAssignerOrganizationFaker.builder().withVersion(version).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV GKV Patient with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void shouldFailOnEmptyAssignerOrganizationBuilder(KbvItaForVersion version) {
        KbvAssignerOrganizationBuilder ob = KbvAssignerOrganizationBuilder.builder().version(version);
        Assertions.assertThrows(BuilderException.class, () -> ((KbvAssignerOrganizationBuilder)ob).build());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV GKV Patient with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void shouldFailOnFakerWithGkvPatient(KbvItaForVersion version) {
        KbvPatient patient = KbvPatientFaker.builder().withKvnrAndInsuranceType(KVNR.random(), InsuranceTypeDe.GKV).withVersion(version).fake();
        try {
            KbvAssignerOrganizationFaker.builder().forPatient(patient).fake();
        }
        catch (RuntimeException e) {
            Assertions.assertEquals(BuilderException.class, e.getClass());
        }
    }

    @Test
    void shouldFailOnFakerWithInvalidPkvPatient01() {
        KbvPatient mockPatient = (KbvPatient)Mockito.mock(KbvPatient.class);
        Mockito.when((Object)mockPatient.hasPkvKvnr()).thenReturn((Object)true);
        Mockito.when((Object)mockPatient.getPkvAssigner()).thenReturn(Optional.empty());
        try {
            KbvAssignerOrganizationFaker.builder().forPatient(mockPatient).fake();
        }
        catch (RuntimeException e) {
            Assertions.assertEquals(BuilderException.class, e.getClass());
        }
    }

    @Test
    void shouldFailOnFakerWithInvalidPkvPatient02() {
        KbvPatient patient = KbvPatientFaker.builder().withKvnrAndInsuranceType(KVNR.random(), InsuranceTypeDe.PKV).fake();
        KbvPatient mockPatient = (KbvPatient)Mockito.mock(KbvPatient.class);
        Mockito.when((Object)mockPatient.hasPkvKvnr()).thenReturn((Object)true);
        Mockito.when((Object)mockPatient.getPkvAssigner()).thenReturn((Object)patient.getPkvAssigner());
        Mockito.when((Object)mockPatient.getPkvAssignerName()).thenReturn(Optional.empty());
        try {
            KbvAssignerOrganizationFaker.builder().forPatient(mockPatient).fake();
        }
        catch (RuntimeException e) {
            Assertions.assertEquals(BuilderException.class, e.getClass());
        }
    }
}

