/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.erp.PrescriptionBuilder;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;

class PrescriptionBuilderTest
extends ErpFhirParsingTest {
    PrescriptionBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build PrescriptionActivation for ErpWorkflowVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void buildSimplePrescription(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        byte[] signed = new byte[]{1, 2, 3, 4};
        Parameters param = PrescriptionBuilder.builder().build(signed);
        Assertions.assertNotNull((Object)param);
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)param);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

