/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.ResourceBuilder;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.utils.PrivateConstructorsUtil;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseDiGAFaker;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseFaker;
import de.gematik.test.erezept.fhir.builder.erp.GemDispenseCloseOperationPharmaceuticalsBuilder;
import de.gematik.test.erezept.fhir.builder.erp.GemErpMedicationFaker;
import de.gematik.test.erezept.fhir.builder.erp.GemOperationInputParameterBuilder;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.r4.erp.ErxMedicationDispense;
import de.gematik.test.erezept.fhir.r4.erp.ErxMedicationDispenseDiGA;
import de.gematik.test.erezept.fhir.r4.erp.GemCloseOperationParameters;
import de.gematik.test.erezept.fhir.r4.erp.GemErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class GemOperationInputParameterBuilderTest
extends ErpFhirParsingTest {
    GemOperationInputParameterBuilderTest() {
    }

    @Test
    void shouldNotInstantiateUtilityClass() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.isUtilityConstructor(GemOperationInputParameterBuilder.class));
    }

    @Test
    void shouldBuildCloseOperationForDiGAMedicationDispense() {
        ErpWorkflowVersion version = ErpWorkflowVersion.V1_4_0;
        ErxMedicationDispenseDiGA medDispense = (ErxMedicationDispenseDiGA)((ErxMedicationDispenseDiGAFaker)ErxMedicationDispenseDiGAFaker.builder().withVersion(version)).fake();
        GemCloseOperationParameters closeOperation = (GemCloseOperationParameters)GemOperationInputParameterBuilder.forClosingDiGA().with(medDispense).version(version).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)closeOperation);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildCloseOperationForMultipleDiGAMedicationDispense() {
        ErpWorkflowVersion version = ErpWorkflowVersion.V1_4_0;
        ErxMedicationDispenseDiGA medDispense = (ErxMedicationDispenseDiGA)((ErxMedicationDispenseDiGAFaker)ErxMedicationDispenseDiGAFaker.builder().withVersion(version)).fake();
        ErxMedicationDispenseDiGA medDispense2 = (ErxMedicationDispenseDiGA)((ErxMedicationDispenseDiGAFaker)ErxMedicationDispenseDiGAFaker.builder().withVersion(version)).fake();
        GemCloseOperationParameters closeOperation = (GemCloseOperationParameters)GemOperationInputParameterBuilder.forClosingDiGA().with(medDispense).with(medDispense2).version(version).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)closeOperation);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest
    @MethodSource(value={"pharmaceuticalsParameterBuilderProvider"})
    void shouldBuildInputOperationParametersForPharmaceuticalMedicationDispense(Supplier<GemDispenseCloseOperationPharmaceuticalsBuilder<?>> builderSupplier) {
        ErpWorkflowVersion version = ErpWorkflowVersion.V1_4_0;
        GemErpMedication medication = GemErpMedicationFaker.builder().withVersion(version).fake();
        ErxMedicationDispense medDispense = (ErxMedicationDispense)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withVersion(version)).withMedication(medication)).fake();
        Parameters closeOperation = builderSupplier.get().version(version).with(medDispense, medication).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)closeOperation);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest
    @MethodSource(value={"pharmaceuticalsParameterBuilderProvider"})
    void shouldBuildInputOperationParametersForSplittedPharmaceuticalMedicationDispense(Supplier<GemDispenseCloseOperationPharmaceuticalsBuilder<?>> builderSupplier) {
        ErpWorkflowVersion version = ErpWorkflowVersion.V1_4_0;
        GemDispenseCloseOperationPharmaceuticalsBuilder<?> builder = builderSupplier.get();
        IntStream.range(0, 4).forEach(i -> {
            GemErpMedication medication = GemErpMedicationFaker.builder().withVersion(version).fake();
            ErxMedicationDispense medDispense = (ErxMedicationDispense)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withVersion(version)).withMedication(medication)).fake();
            builder.with(medDispense, medication);
        });
        Parameters closeOperation = builder.version(version).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)closeOperation);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildEmptyCloseOperationForPharmaceuticals() {
        ErpWorkflowVersion version = ErpWorkflowVersion.V1_4_0;
        GemCloseOperationParameters closeOperation = (GemCloseOperationParameters)GemOperationInputParameterBuilder.forClosingPharmaceuticals().version(version).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)closeOperation);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest
    @MethodSource(value={"dispenseParameterBuilderProvider"})
    void shouldNotAllowEmptyDispenseOperation(Supplier<ResourceBuilder<?, ?>> builderSupplier) {
        ResourceBuilder<?, ?> builder = builderSupplier.get();
        Assertions.assertThrows(BuilderException.class, () -> builder.build());
    }

    @ParameterizedTest
    @MethodSource(value={"closeParameterBuilderProvider"})
    void shouldAllowEmptyParametersForCloseOperation(Supplier<ResourceBuilder<?, ?>> builderSupplier) {
        ResourceBuilder<?, ?> builder = builderSupplier.get();
        Assertions.assertDoesNotThrow(() -> builder.build());
    }

    static Stream<Arguments> closeParameterBuilderProvider() {
        return Stream.of(GemOperationInputParameterBuilder::forClosingPharmaceuticals, GemOperationInputParameterBuilder::forClosingDiGA).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> dispenseParameterBuilderProvider() {
        return Stream.of(GemOperationInputParameterBuilder::forDispensingPharmaceuticals).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> pharmaceuticalsParameterBuilderProvider() {
        return Stream.of(GemOperationInputParameterBuilder::forClosingPharmaceuticals, GemOperationInputParameterBuilder::forClosingPharmaceuticals).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

