/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.erp.GemErpMedicationFaker;
import de.gematik.test.erezept.fhir.r4.erp.GemErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class GemErpMedicationFakerTest
extends ErpFhirParsingTest {
    GemErpMedicationFakerTest() {
    }

    @RepeatedTest(value=5)
    void shouldRandomlyFake() {
        GemErpMedication medication = GemErpMedicationFaker.builder().fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldFakeEverything() {
        try (MockedStatic mockFaker = Mockito.mockStatic(GemFaker.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            mockFaker.when(GemFaker::fakerBool).thenReturn((Object)true);
            GemErpMedication medication = GemErpMedicationFaker.builder().fake();
            ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
            Assertions.assertTrue((boolean)result.isSuccessful());
        }
    }
}

