/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.test.erezept.eml.fhir.profile.EpaMedicationStructDef;
import de.gematik.test.erezept.eml.fhir.r4.EpaMedPznIngredient;
import de.gematik.test.erezept.eml.fhir.valuesets.EpaDrugCategory;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.erp.GemErpMedicationBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationCompoundingFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationFreeTextFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationIngredientFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.r4.erp.GemErpMedication;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.Darreichungsform;
import de.gematik.test.erezept.fhir.valuesets.MedicationCategory;
import de.gematik.test.erezept.fhir.valuesets.StandardSize;
import java.util.Optional;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GemErpMedicationBuilderTest
extends ErpFhirParsingTest {
    GemErpMedicationBuilderTest() {
    }

    @Test
    void shouldBuildGemErpMedicationWithFixedValues() {
        GemErpMedication medication = GemErpMedicationBuilder.builder().version(ErpWorkflowVersion.V1_4_0).category(EpaDrugCategory.C_00).pzn("06313728", "Sumatriptan-1a Pharma 100 mg Tabletten").isVaccine(false).darreichungsform(Darreichungsform.TAB).normgroesse(StandardSize.N1).amount(20L).lotNumber("1234567890").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertFalse((boolean)medication.isVaccine());
        Assertions.assertTrue((boolean)medication.getPzn().isPresent());
        Assertions.assertEquals((Object)"06313728", (Object)((PZN)medication.getPzn().get()).getValue());
        Assertions.assertTrue((boolean)medication.getName().isPresent());
        Assertions.assertEquals((Object)"Sumatriptan-1a Pharma 100 mg Tabletten", medication.getName().get());
        Assertions.assertTrue((boolean)medication.getCategory().isPresent());
        Assertions.assertEquals((Object)EpaDrugCategory.C_00, medication.getCategory().get());
        Assertions.assertTrue((boolean)medication.getDarreichungsform().isPresent());
        Assertions.assertEquals((Object)Darreichungsform.TAB, medication.getDarreichungsform().get());
        Assertions.assertTrue((boolean)medication.getStandardSize().isPresent());
        Assertions.assertEquals((Object)StandardSize.N1, medication.getStandardSize().get());
        Assertions.assertTrue((boolean)medication.getBatchLotNumber().isPresent());
        Assertions.assertEquals((Object)"1234567890", medication.getBatchLotNumber().get());
        Assertions.assertEquals((Object)"1234567890", (Object)medication.getBatch().getLotNumber());
        Assertions.assertTrue((boolean)medication.getAmountNumeratorUnit().isPresent());
        Assertions.assertEquals((Object)"Stk", medication.getAmountNumeratorUnit().get());
        Assertions.assertTrue((boolean)medication.getAmountNumerator().isPresent());
        Assertions.assertEquals((int)20, (Integer)((Integer)medication.getAmountNumerator().get()));
    }

    @Test
    void shouldBuildSimpleMedication() {
        GemErpMedication medication = GemErpMedicationBuilder.builder().version(ErpWorkflowVersion.V1_4_0).pzn("06313728").lotNumber("1234567890").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildSimplestMedication() {
        GemErpMedication medication = GemErpMedicationBuilder.builder().version(ErpWorkflowVersion.V1_4_0).pzn("06313728").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medication);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)medication.getBatchLotNumber().isEmpty());
    }

    @Test
    void shouldBuildFromKbvPznMedication() {
        KbvErpMedication kbvMedication = KbvErpMedicationPZNFaker.builder().withSupplyForm((Darreichungsform)GemFaker.fakerValueSet(Darreichungsform.class, (Enum)Darreichungsform.KPG)).withAmount(100L, "Packung").fake();
        ValidationResult kbvResult = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvMedication);
        Assertions.assertTrue((boolean)kbvResult.isSuccessful());
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvMedication).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertFalse((boolean)gemMedication.getBatchLotNumber().isEmpty());
        Assertions.assertEquals((Object)"123123", gemMedication.getBatchLotNumber().get());
        Assertions.assertEquals((Object)kbvMedication.getPznOptional(), (Object)gemMedication.getPzn());
        Assertions.assertEquals((Object)kbvMedication.getMedicationName(), gemMedication.getName().orElse(null));
        Assertions.assertEquals((Object)kbvMedication.getStandardSize(), gemMedication.getStandardSize().orElse(null));
        Assertions.assertEquals((Object)kbvMedication.getDarreichungsform(), (Object)gemMedication.getDarreichungsform());
        Assertions.assertEquals((int)kbvMedication.getPackagingSizeOrEmpty(), (Integer)gemMedication.getAmountNumerator().orElse(Integer.MIN_VALUE));
        Assertions.assertEquals((Object)kbvMedication.isVaccine(), (Object)gemMedication.isVaccine());
        kbvMedication.getPackagingUnit().ifPresentOrElse(unit -> Assertions.assertEquals((Object)unit, gemMedication.getAmountNumeratorUnit().orElse(null)), () -> Assertions.assertEquals((Object)"Stk", gemMedication.getAmountNumeratorUnit().orElse(null)));
    }

    @Test
    void shouldBuildFromKbvPznMedicationWithDefaultAmountUnit() {
        KbvErpMedication kbvMedication = KbvErpMedicationPZNFaker.builder().withSupplyForm((Darreichungsform)GemFaker.fakerValueSet(Darreichungsform.class, (Enum)Darreichungsform.KPG)).withAmount(3L, null).fake();
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvMedication).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((int)kbvMedication.getPackagingSizeOrEmpty(), (Integer)gemMedication.getAmountNumerator().orElse(Integer.MIN_VALUE));
        Assertions.assertEquals((Object)"Stk", gemMedication.getAmountNumeratorUnit().orElse(null));
    }

    @Test
    void shouldBuildFromFreetextMedication() {
        String freitext = "Dies ist der zu testende Freitext";
        KbvErpMedication kbvMedicationFreeText = KbvErpMedicationFreeTextFaker.builder().withFreeText("Dies ist der zu testende Freitext").withDosageForm(((Darreichungsform)GemFaker.fakerValueSet(Darreichungsform.class)).getDisplay()).fake();
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvMedicationFreeText).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildFromMedicationIngredientWithSpecificParamsCorrect() {
        KbvErpMedication kbvErpMedicationIngredient = KbvErpMedicationIngredientFaker.builder().withStandardSize(StandardSize.N1).withDosageForm(Darreichungsform.AMP.getDisplay()).withIngredientComponent(2L, 1L, "w\u00f6lkchen").withDrugName("MonsterPille").withVaccine(false).withCategory(MedicationCategory.C_00).withAmount("4", 1L, "schwaden").fake();
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvErpMedicationIngredient).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals(Optional.empty(), (Object)gemMedication.getPzn());
        Assertions.assertEquals((Object)"MonsterPille", (Object)((CodeableConcept)gemMedication.getIngredientFirstRep().getItem()).getText());
        Assertions.assertEquals((Object)String.valueOf(Darreichungsform.AMP.getDisplay()), (Object)String.valueOf(((Medication.MedicationIngredientComponent)gemMedication.getIngredient().get(0)).getExtensionFirstRep().getValue()));
        Assertions.assertEquals((Object)MedicationCategory.C_00.getDisplay(), (Object)((EpaDrugCategory)gemMedication.getCategory().orElseThrow()).getDisplay());
        Assertions.assertFalse((boolean)gemMedication.isVaccine());
        Assertions.assertEquals((int)1, (int)gemMedication.getAmount().getDenominator().getValue().intValue());
        Assertions.assertEquals((int)4, (Integer)((Integer)gemMedication.getAmountNumerator().orElseThrow()));
        Assertions.assertEquals((Object)"schwaden", gemMedication.getAmountNumeratorUnit().orElseThrow());
    }

    @Test
    void shouldBuildFromMedicationIngredientWithDefaultParamsCorrect() {
        KbvErpMedication kbvErpMedicationIngredient = KbvErpMedicationIngredientFaker.builder().fake();
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvErpMedicationIngredient).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication, false);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildFromMedicationCompounding() {
        KbvErpMedication kbvMedicComp = KbvErpMedicationCompoundingFaker.builder().fake();
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvMedicComp).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildFromMedicationCompoundingWithoutStrength() {
        KbvErpMedication kbvMedicComp = KbvErpMedicationCompoundingFaker.builder().fake();
        kbvMedicComp.getIngredientFirstRep().setStrength(null);
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvMedicComp).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication, false);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildFromMedicationCompoundingWithMissingStrengthParams() {
        KbvErpMedication kbvMedicComp = KbvErpMedicationCompoundingFaker.builder().withPackaging("im Karton eben").fake();
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvMedicComp).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication, false);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildFromMedicationCompoundingWithoutPzn() {
        KbvErpMedication kbvMedicComp = KbvErpMedicationCompoundingFaker.builder().fake();
        kbvMedicComp.getIngredientFirstRep().setItem(null);
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvMedicComp).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication, false);
        Assertions.assertFalse((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildFromMedicationCompoundingWithSpecificValuesCorrect() {
        String pzn = (String)PZN.random().getValue();
        String medName = "nicorette";
        KbvErpMedication kbvMedicComp = KbvErpMedicationCompoundingFaker.builder().withMedicationIngredient(pzn, "nicorette").withDosageForm(Darreichungsform.ATO).withVaccine(true).withPackaging("im Fass").withCategory(MedicationCategory.C_00).withAmount(2L, 1L, "w\u00f6lkchen").fake();
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvMedicComp).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)"nicorette", (Object)gemMedication.getName().orElse("definetly a wrong name"));
        Assertions.assertTrue((boolean)gemMedication.isVaccine());
        Assertions.assertEquals((Object)"im Fass", (Object)gemMedication.getExtension().stream().filter(xva$0 -> EpaMedicationStructDef.PACKAGING_EXTENSION.matches(new Extension[]{xva$0})).findFirst().map(ext -> (String)ext.getValue().castToString((Base)ext.getValue()).getValue()).orElse("definitely non matching string"));
        Assertions.assertEquals((Object)Darreichungsform.ATO.getDisplay(), (Object)String.valueOf(((Medication.MedicationIngredientComponent)gemMedication.getIngredient().get(0)).getExtensionFirstRep().getValue()));
        Assertions.assertEquals((Object)pzn, (Object)((PZN)((EpaMedPznIngredient)gemMedication.getContained().get(0)).getPzn().orElseThrow()).getValue());
        String medReference = gemMedication.getIngredientFirstRep().getItemReference().getReference();
        Assertions.assertEquals((Object)((Resource)gemMedication.getContained().get(0)).getId(), (Object)medReference);
        Assertions.assertFalse((boolean)gemMedication.getIngredientFirstRep().hasItemCodeableConcept());
    }

    @Test
    void shouldFillMissingAttributesInIngredient() {
        KbvErpMedication kbvErpMedicationIngredient = KbvErpMedicationIngredientFaker.builder().fake();
        kbvErpMedicationIngredient.getIngredientFirstRep().getExtensionFirstRep().setValue(null);
        kbvErpMedicationIngredient.getIngredientFirstRep().setStrength(null);
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvErpMedicationIngredient).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication, false);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldFillPartsOfMissingAttributesInIngredient() {
        KbvErpMedication kbvErpMedicationIngredient = KbvErpMedicationIngredientFaker.builder().fake();
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getNumerator().setSystem(null);
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getNumerator().setCode(null);
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getDenominator().setSystem(null);
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getDenominator().setCode(null);
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getDenominator().setValue(null);
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvErpMedicationIngredient).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication, false);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldFillMissingAttributesInStrengthInCompounding() {
        KbvErpMedication kbvErpMedicationIngredient = KbvErpMedicationCompoundingFaker.builder().fake();
        kbvErpMedicationIngredient.getIngredientFirstRep().getExtensionFirstRep().setValue(null);
        kbvErpMedicationIngredient.getIngredientFirstRep().setStrength(null);
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvErpMedicationIngredient).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication, false);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldFillPartsOfMissingAttributesInStrengthInCompounding() {
        KbvErpMedication kbvErpMedicationIngredient = KbvErpMedicationCompoundingFaker.builder().fake();
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getNumerator().setSystem("http://hl7.org");
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getNumerator().setCode(null);
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getNumerator().setValue(null);
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getDenominator().setSystem("http://hl7.org").setValueElement(null);
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getDenominator().setCode("null");
        kbvErpMedicationIngredient.getIngredientFirstRep().getStrength().getDenominator().setValue(0L);
        GemErpMedication gemMedication = GemErpMedicationBuilder.from((KbvErpMedication)kbvErpMedicationIngredient).version(ErpWorkflowVersion.V1_4_0).lotNumber("123123").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)gemMedication);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldNotBuildAnIngredientCompoundingMedication() {
        GemErpMedicationBuilder builder = GemErpMedicationBuilder.builder().isIngredient().isCompounding().isVaccine(true);
        Assertions.assertThrows(BuilderException.class, () -> ((GemErpMedicationBuilder)builder).build());
    }
}

