/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.erp.FlowTypeBuilder;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import java.util.Arrays;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class FlowTypeBuilderTest
extends ErpFhirParsingTest {
    FlowTypeBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build MedicationDispense with ErpWorkflowVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void buildParametersFlowType160(ErpWorkflowVersion version) {
        Parameters params = FlowTypeBuilder.builder((PrescriptionFlowType)PrescriptionFlowType.FLOW_TYPE_160).version(version).build();
        Assertions.assertNotNull((Object)params);
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)params);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build MedicationDispense with ErpWorkflowVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void buildParametersForAllFlowTypes(ErpWorkflowVersion version) {
        boolean isOldProfile = ErpWorkflowVersion.V1_1_1.compareTo((Enum)version) == 0;
        Arrays.stream(PrescriptionFlowType.values()).filter(flowType -> !isOldProfile || !flowType.equals((Object)PrescriptionFlowType.FLOW_TYPE_209)).forEach(flowType -> {
            Parameters params = FlowTypeBuilder.builder((PrescriptionFlowType)flowType).version(version).build();
            Assertions.assertNotNull((Object)params);
            ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)params);
            Assertions.assertTrue((boolean)result.isSuccessful());
        });
    }
}

