/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseFaker;
import de.gematik.test.erezept.fhir.builder.erp.GemErpMedicationFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.r4.erp.ErxMedicationDispense;
import de.gematik.test.erezept.fhir.r4.erp.GemErpMedication;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import java.util.Date;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.ClearSystemProperty;
import org.junitpioneer.jupiter.SetSystemProperty;

@ClearSystemProperty(key="erp.fhir.profile")
class ErxMedicationDispenseFakerTest
extends ErpFhirParsingTest {
    ErxMedicationDispenseFakerTest() {
    }

    @Test
    void buildFakeMedicationDispenseWithPrescriptionId() {
        ErxMedicationDispense medDispense = (ErxMedicationDispense)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withPrescriptionId((String)PrescriptionId.random().getValue())).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeMedicationDispense() {
        ErxMedicationDispense medDispense = (ErxMedicationDispense)ErxMedicationDispenseFaker.builder().fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeMedicationDispenseWithStatus() {
        ErxMedicationDispense medDispense = (ErxMedicationDispense)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withStatus(MedicationDispense.MedicationDispenseStatus.COMPLETED)).fake();
        ErxMedicationDispense medDispense2 = (ErxMedicationDispense)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withStatus(MedicationDispense.MedicationDispenseStatus.COMPLETED.toCode())).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    @SetSystemProperty(key="erp.fhir.profile", value="1.3.0")
    void shouldFakeWithGivenKbvMedication() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().fake();
        ErxMedicationDispense medDispense = (ErxMedicationDispense)ErxMedicationDispenseFaker.builder().withMedication(medication).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    @SetSystemProperty(key="erp.fhir.profile", value="1.4.0")
    void shouldFakeWithGivenGemErpMedication() {
        GemErpMedication medication = GemErpMedicationFaker.builder().fake();
        ErxMedicationDispense medDispense = (ErxMedicationDispense)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withMedication(medication)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeMedicationDispenseWithHandedOverDate() {
        ErxMedicationDispense medDispense = (ErxMedicationDispense)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withHandedOverDate(new Date())).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeMedicationDispenseWithPreparedDate() {
        ErxMedicationDispense medDispense = (ErxMedicationDispense)ErxMedicationDispenseFaker.builder().withPreparedDate(new Date()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeMedicationDispenseWithBatch() {
        Medication.MedicationBatchComponent batch = new Medication.MedicationBatchComponent();
        batch.setLotNumber("123");
        ErxMedicationDispense medDispense = (ErxMedicationDispense)ErxMedicationDispenseFaker.builder().withBatch(batch).fake();
        ErxMedicationDispense medDispense2 = (ErxMedicationDispense)ErxMedicationDispenseFaker.builder().withBatch("123", new Date()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }
}

