/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseDiGAFaker;
import de.gematik.test.erezept.fhir.extensions.erp.DeepLink;
import de.gematik.test.erezept.fhir.extensions.erp.RedeemCode;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.r4.erp.ErxMedicationDispenseDiGA;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxMedicationDispenseDiGAFakerTest
extends ErpFhirParsingTest {
    ErxMedicationDispenseDiGAFakerTest() {
    }

    @Test
    void shouldFakeDiGAMedicationDispense() {
        ErxMedicationDispenseDiGA medDispense = (ErxMedicationDispenseDiGA)((ErxMedicationDispenseDiGAFaker)ErxMedicationDispenseDiGAFaker.builder().withVersion(ErpWorkflowVersion.V1_4_0)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldFakeDiGAMedicationDispenseWithConcreteValues() {
        String pzn = "12345678";
        String digaName = "Gematico Diabetestherapie";
        String redeemCode = "DE12345678901234";
        String deepLink = "https://gematico.de?redeemCode=DE12345678901234";
        ErxMedicationDispenseDiGA medDispense = (ErxMedicationDispenseDiGA)((ErxMedicationDispenseDiGAFaker)ErxMedicationDispenseDiGAFaker.builder().withVersion(ErpWorkflowVersion.V1_4_0)).withPzn("12345678", "Gematico Diabetestherapie").withRedeemCode("DE12345678901234").withDeepLink("https://gematico.de?redeemCode=DE12345678901234").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)medDispense.isDiGA());
        Assertions.assertTrue((boolean)medDispense.getDeepLink().isPresent());
        Assertions.assertEquals((Object)"https://gematico.de?redeemCode=DE12345678901234", (Object)((DeepLink)medDispense.getDeepLink().get()).getValue());
        Assertions.assertTrue((boolean)medDispense.getRedeemCode().isPresent());
        Assertions.assertEquals((Object)"DE12345678901234", (Object)((RedeemCode)medDispense.getRedeemCode().get()).getValue());
        Assertions.assertEquals((Object)"12345678", (Object)medDispense.getPzn().getValue());
        Assertions.assertEquals((Object)"Gematico Diabetestherapie", (Object)medDispense.getDigaName());
    }
}

