/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseDiGABuilder;
import de.gematik.test.erezept.fhir.builder.erp.GemErpMedicationFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.r4.erp.ErxMedicationDispenseDiGA;
import de.gematik.test.erezept.fhir.r4.erp.GemErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import java.util.Date;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxMedicationDispenseDiGABuilderTest
extends ErpFhirParsingTest {
    ErxMedicationDispenseDiGABuilderTest() {
    }

    @Test
    void shouldBuildDiGAMedicationDispenseFixedValues() {
        KVNR kvnr = KVNR.from((String)"X234567890");
        String telematikId = "606358757";
        String prescriptionId = "162.000.033.491.280.69";
        PZN pzn = PZN.from((String)"12345678");
        GemErpMedication medication = GemErpMedicationFaker.builder().withPzn(pzn, "Gematico Diabetestherapie").fake();
        ErxMedicationDispenseDiGA medicationDispense = ((ErxMedicationDispenseDiGABuilder)((ErxMedicationDispenseDiGABuilder)((ErxMedicationDispenseDiGABuilder)((ErxMedicationDispenseDiGABuilder)((ErxMedicationDispenseDiGABuilder)((ErxMedicationDispenseDiGABuilder)ErxMedicationDispenseDiGABuilder.forKvnr((KVNR)kvnr).version(ErpWorkflowVersion.V1_4_0)).performerId("606358757")).prescriptionId("162.000.033.491.280.69")).medication(medication)).deepLink("https://gematico.de?redeemCode=DE12345678901234").redeemCode("DE12345678901234").status("completed")).whenHandedOver(new Date())).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertNotNull((Object)medicationDispense.getId());
        Assertions.assertEquals((Object)kvnr.getValue(), (Object)medicationDispense.getSubjectId().getValue());
        Assertions.assertEquals((Object)new PrescriptionId("162.000.033.491.280.69"), (Object)medicationDispense.getPrescriptionId());
        Assertions.assertTrue((boolean)medicationDispense.getDosageInstruction().isEmpty());
        Assertions.assertTrue((boolean)medicationDispense.getNote().isEmpty());
    }
}

