/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseBundleFaker;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.SetSystemProperty;

@SetSystemProperty(key="erp.fhir.profile", value="1.3.0")
class ErxMedicationDispenseBundleFakerTest
extends ErpFhirParsingTest {
    ErxMedicationDispenseBundleFakerTest() {
    }

    @Test
    void buildFakeMedicationDispenseBundleBuilder() {
        Bundle bundle = ErxMedicationDispenseBundleFaker.build().fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeMedicationDispenseBundleBuilderWithAmount() {
        Bundle bundle = ErxMedicationDispenseBundleFaker.build().withAmount(4).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertEquals((int)4, (int)bundle.getEntry().size());
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

