/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseBundleBuilder;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseBundleFaker;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.parser.profiles.definitions.ErpWorkflowStructDef;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.r4.erp.ErxMedicationDispense;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;

class ErxMedicationDispenseBundleBuilderTest
extends ErpFhirParsingTest {
    ErxMedicationDispenseBundleBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationInfoReq with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#oldErpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void buildFakedBundle(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        KVNR kvnr = KVNR.from((String)"X110488614");
        String performerId = "3-SMC-B-Testkarte-883110000116873";
        PrescriptionId prescriptionId = PrescriptionId.from((String)"160.000.006.741.854.62");
        Bundle bundle = ErxMedicationDispenseBundleFaker.build().withAmount(2).withKvnr(kvnr).withPerformerId("3-SMC-B-Testkarte-883110000116873").withPrescriptionId(prescriptionId).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((int)2, (int)bundle.getEntry().size());
    }

    @ParameterizedTest(name="[{index}] -> Build MedicationDispense with ErpWorkflowVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#oldErpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void buildEmptyWithAddedFakedDispenses(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        KVNR kvnr = KVNR.random();
        String performerId = GemFaker.fakerTelematikId();
        PrescriptionId prescriptionId = PrescriptionId.random();
        ErxMedicationDispenseBundleBuilder builder = ErxMedicationDispenseBundleBuilder.empty();
        IntStream.range(0, 3).forEach(idx -> builder.add((ErxMedicationDispense)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withKvnr(kvnr)).withPerformer(performerId)).withPrescriptionId(prescriptionId)).fake()));
        Bundle bundle = builder.build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((int)3, (int)bundle.getEntry().size());
    }

    @Test
    void shouldNotHaveAnyProfileForOldProfiles() {
        ErpWorkflowVersion erpWorkflowVersion = ErpWorkflowVersion.V1_1_1;
        KbvItaErpVersion kbvItaErpVersion = KbvItaErpVersion.V1_0_2;
        KVNR kvnr = KVNR.random();
        String performerId = GemFaker.fakerTelematikId();
        PrescriptionId prescriptionId = PrescriptionId.random();
        ErxMedicationDispenseBundleBuilder builder = ErxMedicationDispenseBundleBuilder.empty().version(erpWorkflowVersion);
        IntStream.range(0, 3).forEach(idx -> builder.add((ErxMedicationDispense)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withKvnr(kvnr)).withPerformer(performerId)).withPrescriptionId(prescriptionId)).withVersion(erpWorkflowVersion)).withMedication(KbvErpMedicationPZNFaker.builder().withVersion(kbvItaErpVersion).fake()).fake()));
        Bundle bundle = builder.build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)bundle.getMeta().getProfile().isEmpty());
    }

    @ParameterizedTest
    @MethodSource
    void shouldHaveProfileForNewerProfiles(ErpWorkflowVersion erpWorkflowVersion, KbvItaErpVersion kbvItaErpVersion) {
        KVNR kvnr = KVNR.random();
        String performerId = GemFaker.fakerTelematikId();
        PrescriptionId prescriptionId = PrescriptionId.random();
        ErxMedicationDispenseBundleBuilder builder = ErxMedicationDispenseBundleBuilder.empty().version(erpWorkflowVersion);
        IntStream.range(0, 3).forEach(idx -> builder.add((ErxMedicationDispense)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withKvnr(kvnr)).withPerformer(performerId)).withPrescriptionId(prescriptionId)).withVersion(erpWorkflowVersion)).withMedication(KbvErpMedicationPZNFaker.builder().withVersion(kbvItaErpVersion).fake()).fake()));
        Bundle bundle = builder.build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)bundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertFalse((boolean)bundle.getMeta().getProfile().isEmpty());
        Assertions.assertTrue((boolean)ErpWorkflowStructDef.CLOSE_OPERATION_BUNDLE.matches(bundle.getMeta()));
    }

    static Stream<Arguments> shouldHaveProfileForNewerProfiles() {
        return Stream.of(Arguments.of((Object[])new Object[]{ErpWorkflowVersion.V1_3_0, KbvItaErpVersion.V1_1_0}));
    }
}

