/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.coding.WithSystem;
import de.gematik.bbriccs.fhir.de.DeBasisProfilNamingSystem;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseBuilder;
import de.gematik.test.erezept.fhir.builder.erp.ErxMedicationDispenseFaker;
import de.gematik.test.erezept.fhir.builder.erp.GemErpMedicationFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.r4.erp.ErxMedicationDispense;
import de.gematik.test.erezept.fhir.r4.erp.GemErpMedication;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import java.util.Date;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;
import org.junitpioneer.jupiter.SetSystemProperty;

class ErxMedicationDispenseBuilderTest
extends ErpFhirParsingTest {
    ErxMedicationDispenseBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build MedicationDispense with ErpWorkflowVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#oldErpWorkflowVersions"})
    void buildMedicationDispenseFixedValuesForOldVersions(ErpWorkflowVersion version) {
        String pzn = "06313728";
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withPznMedication("06313728", GemFaker.fakerDrugName()).fake();
        KVNR kvnr = KVNR.from((String)"X234567890");
        String telematikId = "606358757";
        String prescriptionId = "160.100.000.000.011.09";
        String lotNumber = "123456";
        ErxMedicationDispense medicationDispense = ((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)ErxMedicationDispenseBuilder.forKvnr((KVNR)kvnr).version(version)).performerId("606358757")).prescriptionId("160.100.000.000.011.09")).medication(medication).status("completed")).whenPrepared(new Date()).whenHandedOver(new Date())).batch("123456", new Date()).wasSubstituted(Boolean.valueOf(true)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertNotNull((Object)medicationDispense.getId());
        Assertions.assertEquals((Object)kvnr.getValue(), (Object)medicationDispense.getSubjectId().getValue());
        Assertions.assertEquals((Object)new PrescriptionId("160.100.000.000.011.09"), (Object)medicationDispense.getPrescriptionId());
        Assertions.assertTrue((boolean)medicationDispense.getDosageInstruction().isEmpty());
        Assertions.assertTrue((boolean)medicationDispense.getNote().isEmpty());
    }

    @ParameterizedTest(name="[{index}] -> Build MedicationDispense with ErpWorkflowVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void buildMedicationDispenseFixedValues(ErpWorkflowVersion version) {
        String pzn = "06313728";
        KVNR kvnr = KVNR.from((String)"X234567890");
        String telematikId = "606358757";
        String prescriptionId = "160.100.000.000.011.09";
        String lotNumber = "123456";
        ErxMedicationDispenseBuilder medicationDispenseBuilder = ((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)ErxMedicationDispenseBuilder.forKvnr((KVNR)kvnr).version(version)).performerId("606358757")).prescriptionId("160.100.000.000.011.09")).status("completed")).whenPrepared(new Date()).whenHandedOver(new Date())).batch("123456", new Date()).wasSubstituted(Boolean.valueOf(true));
        if (version.compareTo((Enum)ErpWorkflowVersion.V1_3_0) <= 0) {
            medicationDispenseBuilder.medication(KbvErpMedicationPZNFaker.builder().withPznMedication("06313728", GemFaker.fakerDrugName()).fake());
        } else {
            medicationDispenseBuilder.medication(GemErpMedicationFaker.builder().withPzn(PZN.from((String)"06313728"), GemFaker.fakerDrugName()).fake());
        }
        ErxMedicationDispense medicationDispense = medicationDispenseBuilder.build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertNotNull((Object)medicationDispense.getId());
        Assertions.assertTrue((boolean)WithSystem.anyOf((WithSystem[])new WithSystem[]{DeBasisProfilNamingSystem.KVID_PKV_SID, DeBasisProfilNamingSystem.KVID_GKV_SID}).matchesReferenceIdentifier(new Reference[]{medicationDispense.getSubject()}));
        Assertions.assertEquals((Object)kvnr.getValue(), (Object)medicationDispense.getSubjectId().getValue());
        Assertions.assertEquals((Object)PrescriptionId.from((String)"160.100.000.000.011.09"), (Object)medicationDispense.getPrescriptionId());
        Assertions.assertTrue((boolean)medicationDispense.getDosageInstruction().isEmpty());
        Assertions.assertTrue((boolean)medicationDispense.getNote().isEmpty());
    }

    @ParameterizedTest(name="[{index}] -> Build MedicationDispense with ErpWorkflowVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#oldErpWorkflowVersions"})
    void buildMedicationDispenseWithMultipleDosageInstructions(ErpWorkflowVersion version) {
        String pzn = "06313728";
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withPznMedication("06313728", GemFaker.fakerDrugName()).fake();
        KVNR kvnr = KVNR.from((String)"X234567890");
        String telematikId = "606358757";
        String prescriptionId = "160.100.000.000.011.09";
        String lotNumber = "123456";
        ErxMedicationDispense medicationDispense = ((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)((ErxMedicationDispenseBuilder)ErxMedicationDispenseBuilder.forKvnr((KVNR)kvnr).version(version)).performerId("606358757")).prescriptionId("160.100.000.000.011.09")).medication(medication).whenPrepared(new Date()).whenHandedOver(new Date())).batch("123456", new Date()).wasSubstituted(Boolean.valueOf(true)).dosageInstruction("nur nach dem Essen").dosageInstruction("nicht vor dem Schlafen").note("in 7 Tagen R\u00fccksprache mit dem Hausarzt halten").build();
        Assertions.assertNotNull((Object)medicationDispense.getId());
        Assertions.assertEquals((Object)kvnr.getValue(), (Object)medicationDispense.getSubjectId().getValue());
        Assertions.assertEquals((Object)new PrescriptionId("160.100.000.000.011.09"), (Object)medicationDispense.getPrescriptionId());
        Assertions.assertEquals((int)2, (int)medicationDispense.getDosageInstruction().size());
        Assertions.assertEquals((Object)"nur nach dem Essen", medicationDispense.getDosageInstructionText().get(0));
        Assertions.assertEquals((Object)"nicht vor dem Schlafen", medicationDispense.getDosageInstructionText().get(1));
        Assertions.assertEquals((int)1, (int)medicationDispense.getNote().size());
        Assertions.assertEquals((Object)"in 7 Tagen R\u00fccksprache mit dem Hausarzt halten", (Object)medicationDispense.getNoteFirstRep().getText());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build MedicationDispense with faker and E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#oldErpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void buildMedicationDispenseWithFaker01(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        KVNR kvnr = KVNR.from((String)"X234567890");
        String performerId = "01234567890";
        PrescriptionId prescriptionId = PrescriptionId.random();
        ErxMedicationDispense medicationDispense = (ErxMedicationDispense)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withKvnr(kvnr)).withPerformer("01234567890")).withPrescriptionId(prescriptionId)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertNotNull((Object)medicationDispense.getId());
        Assertions.assertEquals((Object)prescriptionId, (Object)medicationDispense.getPrescriptionId());
        Assertions.assertEquals((Object)kvnr.getValue(), (Object)medicationDispense.getSubjectId().getValue());
        Assertions.assertEquals((Object)"01234567890", (Object)medicationDispense.getPerformerIdFirstRep());
    }

    @ParameterizedTest(name="[{index}] -> Build MedicationDispense with faker and E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#oldErpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void buildMedicationDispenseWithFaker02(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        KVNR kvnr = KVNR.from((String)"X234567890");
        String performerId = "01234567890";
        PrescriptionId prescriptionId = new PrescriptionId("200.100.000.000.011.09");
        ErxMedicationDispense medicationDispense = (ErxMedicationDispense)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withKvnr(kvnr)).withPerformer("01234567890")).withPrescriptionId(prescriptionId)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertNotNull((Object)medicationDispense.getId());
        Assertions.assertEquals((Object)kvnr.getValue(), (Object)medicationDispense.getSubjectId().getValue());
        Assertions.assertEquals((Object)prescriptionId, (Object)medicationDispense.getPrescriptionId());
        Assertions.assertEquals((Object)"01234567890", (Object)medicationDispense.getPerformerIdFirstRep());
    }

    @ParameterizedTest(name="[{index}] -> Build MedicationDispense with faker and E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void throwExceptionWhileBuildMedicationDispenseWithFaker02(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        ErxMedicationDispenseBuilder erxMedicationDispensebuilder = ErxMedicationDispenseBuilder.forKvnr((KVNR)KVNR.random());
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().fake();
        if (erpFhirProfileVersion.compareTo(ErpWorkflowVersion.V1_3_0.getVersion()) <= 0) {
            GemErpMedication gemMedication = GemErpMedication.fromMedication((Medication)medication);
            erxMedicationDispensebuilder.medication(gemMedication);
        } else {
            erxMedicationDispensebuilder.medication(medication);
        }
        Assertions.assertThrows(BuilderException.class, () -> ((ErxMedicationDispenseBuilder)erxMedicationDispensebuilder).build());
    }

    @ParameterizedTest(name="[{index}] -> Build MedicationDispense with faker and E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#oldErpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void buildMedicationDispenseWithFaker03(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        KVNR kvnr = KVNR.from((String)"X234567890");
        String performerId = "01234567890";
        PrescriptionId prescriptionId = new PrescriptionId("160.100.000.000.011.09");
        ErxMedicationDispense medicationDispense = (ErxMedicationDispense)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withKvnr(kvnr)).withPerformer("01234567890")).withPrescriptionId(prescriptionId)).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)medicationDispense);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertNotNull((Object)medicationDispense.getId());
        Assertions.assertEquals((Object)kvnr.getValue(), (Object)medicationDispense.getSubjectId().getValue());
        Assertions.assertEquals((Object)prescriptionId, (Object)medicationDispense.getPrescriptionId());
        Assertions.assertEquals((Object)"01234567890", (Object)medicationDispense.getPerformerIdFirstRep());
        if (ErpWorkflowVersion.getDefaultVersion().compareTo((Enum)ErpWorkflowVersion.V1_3_0) <= 0) {
            Assertions.assertFalse((boolean)medicationDispense.getContainedKbvMedication().isEmpty());
        } else {
            Assertions.assertTrue((boolean)medicationDispense.getContainedKbvMedication().isEmpty());
        }
    }

    @SetSystemProperty(key="erp.fhir.profile", value="1.3.0")
    @Test
    void shouldBuildMedicationDispenseWithDefaultVersion() {
        KVNR kvnr = KVNR.from((String)"X234567890");
        String performerId = "01234567890";
        PrescriptionId prescriptionId = new PrescriptionId("160.100.000.000.011.09");
        ErxMedicationDispense medicationDispense = (ErxMedicationDispense)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withKvnr(kvnr)).withPerformer("01234567890")).withPrescriptionId(prescriptionId)).fake();
        String profile = ((CanonicalType)medicationDispense.getMeta().getProfile().get(0)).asStringValue();
        String profileVersion = profile.split("\\|")[1];
        Assertions.assertTrue((boolean)ErpWorkflowVersion.getDefaultVersion().isEqual(profileVersion));
    }

    @ParameterizedTest
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void shouldThrowOnDispensingWrongMedicationForProfileVersion(ErpWorkflowVersion version) {
        ErxMedicationDispenseBuilder medicationDispenseBuilder = ((ErxMedicationDispenseFaker)ErxMedicationDispenseFaker.builder().withVersion(version)).toBuilder();
        if (version.compareTo((Enum)ErpWorkflowVersion.V1_3_0) <= 0) {
            medicationDispenseBuilder.medication(GemErpMedicationFaker.builder().fake());
        } else {
            medicationDispenseBuilder.medication(KbvErpMedicationPZNFaker.builder().fake());
        }
        Assertions.assertThrows(BuilderException.class, () -> ((ErxMedicationDispenseBuilder)medicationDispenseBuilder).build());
    }
}

