/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.fhir.de.valueset.ActCode;
import de.gematik.bbriccs.fhir.de.valueset.ConsentScope;
import de.gematik.test.erezept.fhir.builder.erp.ErxConsentBuilder;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.r4.erp.ErxConsent;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;

class ErxConsentBuilderTest
extends ErpFhirParsingTest {
    ErxConsentBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationInfoReq with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void buildConsentWithFixedValues(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        KVNR kvnr = KVNR.asPkv((String)"X234567890");
        ErxConsent erxConsent = ErxConsentBuilder.forKvnr((KVNR)kvnr).policyRule(ActCode.OPTIN).status(Consent.ConsentState.ACTIVE).scope(ConsentScope.PATIENT_PRIVACY).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)erxConsent);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationInfoReq with E-Rezept WorkflowVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void buildVersionedConsentWithFixedValues(ErpWorkflowVersion version) {
        KVNR kvid = KVNR.from((String)"X234567890");
        ErxConsent erxConsent = ErxConsentBuilder.forKvnr((KVNR)kvid).version(version).policyRule(ActCode.OPTIN).status(Consent.ConsentState.ACTIVE).scope(ConsentScope.PATIENT_PRIVACY).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)erxConsent);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

