/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.de.value.IKNR;
import de.gematik.test.erezept.fhir.builder.erp.ErxChargeItemFaker;
import de.gematik.test.erezept.fhir.builder.erp.ErxComChargeItemBuilder;
import de.gematik.test.erezept.fhir.builder.erp.ErxComDispReqBuilder;
import de.gematik.test.erezept.fhir.builder.erp.ErxComInfoReqBuilder;
import de.gematik.test.erezept.fhir.builder.erp.ErxComReplyBuilder;
import de.gematik.test.erezept.fhir.builder.erp.ErxComRepresentativeBuilder;
import de.gematik.test.erezept.fhir.builder.erp.ErxCommunicationBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.extensions.erp.SupplyOptionsType;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.r4.erp.ErxChargeItem;
import de.gematik.test.erezept.fhir.r4.erp.ErxCommunication;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.AccessCode;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.values.TaskId;
import de.gematik.test.erezept.fhir.values.json.CommunicationDisReqMessage;
import de.gematik.test.erezept.fhir.values.json.CommunicationReplyMessage;
import de.gematik.test.erezept.fhir.valuesets.AvailabilityStatus;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;

class ErxCommunicationBuilderTest
extends ErpFhirParsingTest {
    ErxCommunicationBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationInfoReq with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void shouldBuildCommunicationInfoReqFixedValues(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().fake();
        ErxCommunication infoReq = ((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)ErxCommunicationBuilder.forInfoRequest((String)"Hallo, das ist meine Request Nachricht!").basedOn(TaskId.from((String)"4711"))).status("unknown")).medication(medication)).insurance(IKNR.asDefaultIknr((String)"104212059"))).receiver("606358757")).substitution(false)).flowType(PrescriptionFlowType.FLOW_TYPE_160)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)infoReq);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildOldCommunicationInfoReqFixedValues() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withVersion(KbvItaErpVersion.V1_0_2).fake();
        ErxCommunication infoReq = ((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)ErxCommunicationBuilder.forInfoRequest((String)"Hallo, das ist meine Request Nachricht!").version(ErpWorkflowVersion.V1_1_1)).basedOn(TaskId.from((String)"4711"))).status("unknown")).medication(medication)).insurance(IKNR.asArgeIknr((String)"104212059"))).receiver("606358757")).substitution(false)).flowType(PrescriptionFlowType.FLOW_TYPE_160)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)infoReq);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationInfoReq with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void shouldThrowOnMissingMedicationForInfoReq(ErpWorkflowVersion version) {
        ErxComInfoReqBuilder builder = (ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)ErxCommunicationBuilder.forInfoRequest((String)"Hallo, das ist meine Request Nachricht!").version(version)).basedOn(TaskId.from((String)"4711"))).insurance(IKNR.asDefaultIknr((String)"104212059"))).receiver("606358757")).flowType(PrescriptionFlowType.FLOW_TYPE_160);
        Assertions.assertThrows(BuilderException.class, () -> ((ErxComInfoReqBuilder)builder).build());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationInfoReq with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void shouldThrowOnMissingFlowTypeForInfoReq(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().fake();
        ErxComInfoReqBuilder builder = (ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)((ErxComInfoReqBuilder)ErxCommunicationBuilder.forInfoRequest((String)"Hallo, das ist meine Request Nachricht!").basedOn(TaskId.from((String)"4711"))).insurance(IKNR.asDefaultIknr((String)"104212059"))).medication(medication)).receiver("606358757");
        Assertions.assertThrows(BuilderException.class, () -> ((ErxComInfoReqBuilder)builder).build());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationDispReq with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void shouldBuildDispReqFixedValues(ErpWorkflowVersion version) {
        TaskId taskId = TaskId.from((PrescriptionId)PrescriptionId.random());
        AccessCode accessCode = AccessCode.random();
        ErxCommunication dispReq = ((ErxComDispReqBuilder)((ErxComDispReqBuilder)((ErxComDispReqBuilder)((ErxComDispReqBuilder)ErxCommunicationBuilder.forDispenseRequest((CommunicationDisReqMessage)new CommunicationDisReqMessage()).version(version)).basedOn(taskId, accessCode)).receiver("606358757")).flowType(PrescriptionFlowType.FLOW_TYPE_160)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)dispReq);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)taskId, (Object)dispReq.getBasedOnReferenceId());
        Assertions.assertEquals((Object)accessCode, dispReq.getBasedOnAccessCode().orElseThrow());
    }

    @Test
    void shouldBuildOldDispReqFixedValues() {
        TaskId taskId = TaskId.from((PrescriptionId)PrescriptionId.random());
        AccessCode accessCode = AccessCode.random();
        ErxCommunication dispReq = ((ErxComDispReqBuilder)((ErxComDispReqBuilder)((ErxComDispReqBuilder)((ErxComDispReqBuilder)ErxCommunicationBuilder.forDispenseRequest((CommunicationDisReqMessage)new CommunicationDisReqMessage()).version(ErpWorkflowVersion.V1_1_1)).basedOn(taskId, accessCode)).receiver("606358757")).flowType(PrescriptionFlowType.FLOW_TYPE_160)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)dispReq);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)taskId, (Object)dispReq.getBasedOnReferenceId());
        Assertions.assertEquals((Object)accessCode, dispReq.getBasedOnAccessCode().orElseThrow());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationRepresentative with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void shouldBuildRepresentative(ErpWorkflowVersion version) {
        TaskId taskId = TaskId.from((String)"4711");
        AccessCode accessCode = AccessCode.fromString((String)"777bea0e13cc9c42ceec14aec3ddee2263325dc2c6c699db115f58fe423607ea");
        ErxCommunication representative = ((ErxComRepresentativeBuilder)((ErxComRepresentativeBuilder)((ErxComRepresentativeBuilder)((ErxComRepresentativeBuilder)((ErxComRepresentativeBuilder)ErxCommunicationBuilder.forRepresentative((String)"Bitte f\u00fcr mich abholen").version(version)).basedOn(taskId, accessCode)).receiver("X123456789")).sender("X987654321")).flowType(PrescriptionFlowType.FLOW_TYPE_160)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)representative);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildOldRepresentative() {
        TaskId taskId = TaskId.from((String)"4711");
        AccessCode accessCode = AccessCode.fromString((String)"777bea0e13cc9c42ceec14aec3ddee2263325dc2c6c699db115f58fe423607ea");
        ErxCommunication representative = ((ErxComRepresentativeBuilder)((ErxComRepresentativeBuilder)((ErxComRepresentativeBuilder)((ErxComRepresentativeBuilder)((ErxComRepresentativeBuilder)ErxCommunicationBuilder.forRepresentative((String)"Bitte f\u00fcr mich abholen").version(ErpWorkflowVersion.V1_1_1)).basedOn(taskId, accessCode)).receiver("X123456789")).sender("X987654321")).flowType(PrescriptionFlowType.FLOW_TYPE_160)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)representative);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationDispReq with E-Rezept FHIR Profiles {0} and missing Task")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void shouldThrowOnMissingTaskForDispReq(ErpWorkflowVersion version) {
        CommunicationDisReqMessage message = new CommunicationDisReqMessage();
        ErxComDispReqBuilder builder = (ErxComDispReqBuilder)((ErxComDispReqBuilder)ErxCommunicationBuilder.forDispenseRequest((CommunicationDisReqMessage)message).version(version)).receiver("606358757");
        Assertions.assertThrows(BuilderException.class, () -> ((ErxComDispReqBuilder)builder).build());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationReply with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void shouldBuildCommunicationReplyFixedValues(ErpWorkflowVersion version) {
        ErxCommunication reply = ((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)ErxCommunicationBuilder.asReply((CommunicationReplyMessage)new CommunicationReplyMessage()).version(version)).basedOn(TaskId.from((String)"4711"))).receiver("X234567890")).sender("606358757")).availabilityStatus(AvailabilityStatus.AS_30)).supplyOptions(SupplyOptionsType.SHIPMENT)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)reply);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildOldCommunicationReplyFixedValues() {
        ErxCommunication reply = ((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)ErxCommunicationBuilder.asReply((CommunicationReplyMessage)new CommunicationReplyMessage()).version(ErpWorkflowVersion.V1_1_1)).basedOn(TaskId.from((String)"4711"))).receiver("X234567890")).sender("606358757")).availabilityStatus(AvailabilityStatus.AS_30)).supplyOptions(SupplyOptionsType.SHIPMENT)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)reply);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationReply with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void shouldBuildCommunicationReplyWithDefaultSupplyOptions(ErpWorkflowVersion version) {
        ErxCommunication reply = ((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)((ErxComReplyBuilder)ErxCommunicationBuilder.asReply((CommunicationReplyMessage)new CommunicationReplyMessage()).version(version)).basedOn(TaskId.from((String)"4711"))).receiver("X234567890")).sender("606358757")).availabilityStatus(AvailabilityStatus.AS_30)).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)reply);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationChangeRequest with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void shouldBuildCommunicationChargeChangeRequest(ErpWorkflowVersion version) {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withPrescriptionId(PrescriptionId.random()).fake();
        ErxCommunication changeReq = ((ErxComChargeItemBuilder)((ErxComChargeItemBuilder)((ErxComChargeItemBuilder)ErxCommunicationBuilder.forChargeItemChangeRequest((String)"Hallo, das ist meine ChargeItem Change Request Nachricht!").version(version)).basedOn(chargeItem).receiver("606358757")).sender("X234567890")).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)changeReq);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildOldCommunicationChargeChangeRequest() {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withPrescriptionId(PrescriptionId.random()).fake();
        ErxCommunication changeReq = ((ErxComChargeItemBuilder)((ErxComChargeItemBuilder)((ErxComChargeItemBuilder)ErxCommunicationBuilder.forChargeItemChangeRequest((String)"Hallo, das ist meine ChargeItem Change Request Nachricht!").version(ErpWorkflowVersion.V1_1_1)).basedOn(chargeItem).receiver("606358757")).sender("X234567890")).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)changeReq);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationChangeRequest with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void shouldBuildCommunicationChargeChangeRequest02(ErpWorkflowVersion version) {
        TaskId taskId = TaskId.from((String)"123");
        ErxCommunication changeReq = ((ErxComChargeItemBuilder)((ErxComChargeItemBuilder)((ErxComChargeItemBuilder)ErxCommunicationBuilder.forChargeItemChangeRequest((String)"Hallo, das ist meine ChargeItem Change Request Nachricht!").version(version)).basedOn(taskId).receiver("606358757")).sender("X234567890")).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)changeReq);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build CommunicationChangeReply with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpWorkflowVersions"})
    void shouldBuildCommunicationChargeChangeReply(ErpWorkflowVersion version) {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withPrescriptionId(PrescriptionId.random()).fake();
        ErxCommunication changeReply = ((ErxComChargeItemBuilder)((ErxComChargeItemBuilder)((ErxComChargeItemBuilder)ErxCommunicationBuilder.forChargeItemChangeReply((String)"ChargeItem Change Request erhalten, das hier ist die Antwort!").version(version)).basedOn(chargeItem).receiver("X234567890")).sender("606358757")).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)changeReply);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldBuildOldCommunicationChargeChangeReply() {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withPrescriptionId(PrescriptionId.random()).fake();
        ErxCommunication changeReply = ((ErxComChargeItemBuilder)((ErxComChargeItemBuilder)((ErxComChargeItemBuilder)ErxCommunicationBuilder.forChargeItemChangeReply((String)"ChargeItem Change Request erhalten, das hier ist die Antwort!").version(ErpWorkflowVersion.V1_1_1)).basedOn(chargeItem).receiver("X234567890")).sender("606358757")).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)changeReply);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

