/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.dav.DavPkvAbgabedatenFaker;
import de.gematik.test.erezept.fhir.builder.erp.ErxChargeItemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpBundleFaker;
import de.gematik.test.erezept.fhir.extensions.erp.MarkingFlag;
import de.gematik.test.erezept.fhir.parser.profiles.version.PatientenrechnungVersion;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvAbgabedatenBundle;
import de.gematik.test.erezept.fhir.r4.erp.ErxChargeItem;
import de.gematik.test.erezept.fhir.r4.erp.ErxReceipt;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.AccessCode;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.values.TelematikID;
import java.util.Date;
import java.util.UUID;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ErxChargeItemFakerTest
extends ErpFhirParsingTest {
    ErxChargeItemFakerTest() {
    }

    @Test
    void buildFakeChargeItemWithVersion() {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withVersion(PatientenrechnungVersion.V1_0_0).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeChargeItemWithAccessCode() {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withAccessCode(AccessCode.random()).fake();
        ErxChargeItem chargeItem2 = ErxChargeItemFaker.builder().withAccessCode((String)AccessCode.random().getValue()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakeChargeItemWithStatus() {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withStatus(ChargeItem.ChargeItemStatus.BILLABLE).fake();
        ErxChargeItem chargeItem2 = ErxChargeItemFaker.builder().withStatus(ChargeItem.ChargeItemStatus.BILLABLE.toCode()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakeChargeItemWithSubject() {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withSubject(KVNR.random(), GemFaker.fakerName()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeChargeItemWithReceipt() {
        ErxReceipt erxReceipt = new ErxReceipt();
        erxReceipt.setId("12345");
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withReceipt(erxReceipt).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeChargeItemWithEnterer() {
        TelematikID telematikId = (TelematikID)Mockito.mock(TelematikID.class);
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withEnterer(telematikId).fake();
        ErxChargeItem chargeItem2 = ErxChargeItemFaker.builder().withEnterer(telematikId.toString()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakeChargeItemWithEnteredDate() {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withEnteredDate(new Date()).fake();
        ErxChargeItem chargeItem2 = ErxChargeItemFaker.builder().withEnteredDate(new Date(), TemporalPrecisionEnum.SECOND).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakeChargeItemWithMarkingFlag() {
        MarkingFlag markingFlag = MarkingFlag.with((boolean)true, (boolean)false, (boolean)false);
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withMarkingFlag(markingFlag).fake();
        ErxChargeItem chargeItem2 = ErxChargeItemFaker.builder().withMarkingFlag(true, false, false).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakeChargeItemWithVerordnung() {
        KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().fake();
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withVerordnung(kbvBundle.asReference()).fake();
        ErxChargeItem chargeItem2 = ErxChargeItemFaker.builder().withVerordnung(kbvBundle).fake();
        ErxChargeItem chargeItem3 = ErxChargeItemFaker.builder().withVerordnung(kbvBundle.getLogicalId()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem2);
        ValidationResult result3 = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem3);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
        Assertions.assertTrue((boolean)result3.isSuccessful());
    }

    @Test
    void buildFakeChargeItemWithAbgabedatensatz() {
        DavPkvAbgabedatenBundle davBundle = DavPkvAbgabedatenFaker.builder((PrescriptionId)GemFaker.fakerPrescriptionId()).fake();
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withAbgabedatensatz(davBundle, b -> "helloworld".getBytes()).fake();
        ErxChargeItem chargeItem2 = ErxChargeItemFaker.builder().withAbgabedatensatz(UUID.randomUUID().toString(), "faked binary content".getBytes()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }
}

