/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.dav.DavPkvAbgabedatenFaker;
import de.gematik.test.erezept.fhir.builder.erp.ErxChargeItemBuilder;
import de.gematik.test.erezept.fhir.builder.erp.ErxChargeItemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpBundleFaker;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.parser.profiles.version.PatientenrechnungVersion;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvAbgabedatenBundle;
import de.gematik.test.erezept.fhir.r4.erp.ErxChargeItem;
import de.gematik.test.erezept.fhir.r4.erp.ErxReceipt;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.AccessCode;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import java.util.UUID;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.junitpioneer.jupiter.ClearSystemProperty;
import org.mockito.Mockito;

class ErxChargeItemBuilderTest
extends ErpFhirParsingTest {
    ErxChargeItemBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build ChargeItem using old profiles {0}")
    @ValueSource(booleans={true, false})
    void buildChargeItemFixedValues(boolean oldProfiles) {
        ErpWorkflowNamingSystem prescriptionIdSystem = oldProfiles ? ErpWorkflowNamingSystem.PRESCRIPTION_ID : ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        PrescriptionId prescriptionId = PrescriptionId.random((ErpWorkflowNamingSystem)prescriptionIdSystem);
        DavPkvAbgabedatenBundle davBundle = DavPkvAbgabedatenFaker.builder((PrescriptionId)prescriptionId).fake();
        KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().fake();
        ErxReceipt erxReceipt = (ErxReceipt)Mockito.mock(ErxReceipt.class);
        Mockito.when((Object)erxReceipt.getId()).thenReturn((Object)"Bundle/12345");
        ErxChargeItemBuilder chargeItemBuilder = ErxChargeItemBuilder.forPrescription((PrescriptionId)prescriptionId).accessCode((String)AccessCode.random().getValue()).status("billable").enterer("606358757").subject(KVNR.from((String)"X234567890"), GemFaker.insuranceName()).receipt(erxReceipt).markingFlag(false, false, true).verordnung(kbvBundle).abgabedatensatz(davBundle, b -> "helloworld".getBytes());
        if (!oldProfiles) {
            chargeItemBuilder.version(PatientenrechnungVersion.V1_0_0);
        }
        ErxChargeItem chargeItem = chargeItemBuilder.build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build ChargeItem using old profiles {0}")
    @ValueSource(booleans={true, false})
    void buildChargeItemFixedValuesWithoutMarkingFlags(boolean oldProfiles) {
        ErpWorkflowNamingSystem prescriptionIdSystem = oldProfiles ? ErpWorkflowNamingSystem.PRESCRIPTION_ID : ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        PrescriptionId prescriptionId = PrescriptionId.random((ErpWorkflowNamingSystem)prescriptionIdSystem);
        DavPkvAbgabedatenBundle davBundle = DavPkvAbgabedatenFaker.builder((PrescriptionId)prescriptionId).fake();
        ErxReceipt erxReceipt = (ErxReceipt)Mockito.mock(ErxReceipt.class);
        Mockito.when((Object)erxReceipt.getId()).thenReturn((Object)"Bundle/12345");
        ErxChargeItemBuilder chargeItemBuilder = ErxChargeItemBuilder.forPrescription((PrescriptionId)prescriptionId).accessCode((String)AccessCode.random().getValue()).status("billable").enterer("606358757").subject(KVNR.from((String)"X234567890"), GemFaker.insuranceName()).receipt(erxReceipt).verordnung(UUID.randomUUID().toString()).abgabedatensatz(davBundle, b -> "helloworld".getBytes());
        if (!oldProfiles) {
            chargeItemBuilder.version(PatientenrechnungVersion.V1_0_0);
        }
        ErxChargeItem chargeItem = chargeItemBuilder.build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build ChargeItem using old profiles {0}")
    @ValueSource(booleans={true, false})
    void buildChargeItemForPost(boolean oldProfiles) {
        ErpWorkflowNamingSystem prescriptionIdSystem = oldProfiles ? ErpWorkflowNamingSystem.PRESCRIPTION_ID : ErpWorkflowNamingSystem.PRESCRIPTION_ID_121;
        PrescriptionId prescriptionId = PrescriptionId.random((ErpWorkflowNamingSystem)prescriptionIdSystem);
        DavPkvAbgabedatenBundle davBundle = DavPkvAbgabedatenFaker.builder((PrescriptionId)prescriptionId).fake();
        ErxChargeItemBuilder chargeItemBuilder = ErxChargeItemBuilder.forPrescription((PrescriptionId)prescriptionId).status("billable").enterer("606358757").subject(KVNR.from((String)"X234567890"), GemFaker.insuranceName()).abgabedatensatz(davBundle, b -> "helloworld".getBytes());
        if (!oldProfiles) {
            chargeItemBuilder.version(PatientenrechnungVersion.V1_0_0);
        }
        ErxChargeItem chargeItem = chargeItemBuilder.build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldRemoveContainedResources() {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withPrescriptionId(PrescriptionId.random()).fake();
        chargeItem.removeContainedResources();
        Assertions.assertFalse((boolean)chargeItem.hasContained());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldRemoveAccessCode() {
        ErxChargeItem chargeItem = ErxChargeItemFaker.builder().withPrescriptionId(PrescriptionId.random()).withVersion(PatientenrechnungVersion.V1_0_0).withAccessCode("123").fake();
        Assertions.assertTrue((boolean)chargeItem.isFromNewProfiles());
        Assertions.assertTrue((boolean)chargeItem.getAccessCode().isPresent());
        chargeItem.removeAccessCode();
        Assertions.assertFalse((boolean)chargeItem.getAccessCode().isPresent());
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @ParameterizedTest(name="[{index}] -> Build ErxChargeItem with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void shouldSetPrescriptionIdSystemCorrect(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        PrescriptionId prescriptionId = PrescriptionId.random();
        DavPkvAbgabedatenBundle davBundle = DavPkvAbgabedatenFaker.builder((PrescriptionId)prescriptionId).fake();
        ErxChargeItem chargeItem = ErxChargeItemBuilder.forPrescription((PrescriptionId)prescriptionId).status("billable").enterer("606358757").subject(KVNR.from((String)"X234567890"), GemFaker.insuranceName()).abgabedatensatz(davBundle, b -> "helloworld".getBytes()).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

