/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.dav;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.IKNR;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.dav.PharmacyOrganizationFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.AbdaErpPkvVersion;
import de.gematik.test.erezept.fhir.r4.dav.PharmacyOrganization;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PharmacyOrganizationFakerTest
extends ErpFhirParsingTest {
    PharmacyOrganizationFakerTest() {
    }

    @Test
    void buildFakePharmacyOrganizationWithVersion() {
        PharmacyOrganization pharmacy = PharmacyOrganizationFaker.builder().withVersion(AbdaErpPkvVersion.getDefaultVersion()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)pharmacy);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakePharmacyOrganizationWithName() {
        PharmacyOrganization pharmacy = PharmacyOrganizationFaker.builder().withName(GemFaker.fakerName()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)pharmacy);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakePharmacyOrganizationWithIknr() {
        IKNR iknr = IKNR.randomSidIknr();
        PharmacyOrganization pharmacy = PharmacyOrganizationFaker.builder().withIknr(iknr).fake();
        PharmacyOrganization pharmacy2 = PharmacyOrganizationFaker.builder().withIknr((String)iknr.getValue()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)pharmacy);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)pharmacy2);
        Assertions.assertEquals((Object)iknr, (Object)pharmacy.getIknr());
        Assertions.assertEquals((Object)iknr, (Object)pharmacy2.getIknr());
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakePharmacyOrganizationWithAddress() {
        PharmacyOrganization pharmacy = PharmacyOrganizationFaker.builder().withAddress(GemFaker.fakerCountry(), GemFaker.fakerCity(), GemFaker.fakerZipCode(), GemFaker.fakerStreetName()).fake();
        PharmacyOrganization pharmacy2 = PharmacyOrganizationFaker.builder().withAddress(GemFaker.fakerCity(), GemFaker.fakerZipCode(), GemFaker.fakerStreetName()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)pharmacy);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)pharmacy2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }
}

