/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.dav;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.IKNR;
import de.gematik.bbriccs.fhir.de.valueset.Country;
import de.gematik.test.erezept.fhir.builder.dav.PharmacyOrganizationBuilder;
import de.gematik.test.erezept.fhir.builder.dav.PharmacyOrganizationFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.AbdaErpPkvVersion;
import de.gematik.test.erezept.fhir.r4.dav.PharmacyOrganization;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class PharmacyOrganizationBuilderTest
extends ErpFhirParsingTest {
    PharmacyOrganizationBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build DAV DispensedMedication with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#abdaErpPkvVersions"})
    void buildPharmacyOrganizationWithFixedValues(AbdaErpPkvVersion version) {
        String organizationResourceId = "d55c6c01-057b-483d-a1eb-2bd1e182551f";
        PharmacyOrganization pharmacy = ((PharmacyOrganizationBuilder)((PharmacyOrganizationBuilder)PharmacyOrganizationBuilder.builder().version(version).setId("d55c6c01-057b-483d-a1eb-2bd1e182551f")).name("Adler-Apotheke")).iknr(IKNR.asDefaultIknr((String)"757299999")).address(Country.D, "Berlin", "10623", "Wegelystra\u00dfe 3").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)pharmacy);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)"Adler-Apotheke", (Object)pharmacy.getName());
        Assertions.assertEquals((Object)IKNR.asDefaultIknr((String)"757299999"), (Object)pharmacy.getIknr());
    }

    @Test
    void buildPharmacyOrganizationWithFaker() {
        for (int i = 0; i < 5; ++i) {
            PharmacyOrganization pharmacy = PharmacyOrganizationFaker.builder().fake();
            ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)pharmacy);
            Assertions.assertTrue((boolean)result.isSuccessful());
        }
    }
}

