/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.dav;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.dav.DavPkvDispensedMedicationBuilder;
import de.gematik.test.erezept.fhir.parser.profiles.version.AbdaErpPkvVersion;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvDispensedMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import java.util.Date;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DavPkvDispensedMedicationBuilderTest
extends ErpFhirParsingTest {
    DavPkvDispensedMedicationBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build DAV DispensedMedication with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#abdaErpPkvVersions"})
    void buildMedicationDispenseWithFixedValues(AbdaErpPkvVersion version) {
        String pharmacyId = "ce10f18e-7cce-4f67-aca5-e2050f965b60";
        String invoiceId = "ce10f18e-7cce-4f67-aca5-e2050f965b61";
        DavPkvDispensedMedication md = DavPkvDispensedMedicationBuilder.builder().version(version).status("completed").prescription(PrescriptionId.random((PrescriptionFlowType)PrescriptionFlowType.FLOW_TYPE_200)).pharmacy("ce10f18e-7cce-4f67-aca5-e2050f965b60").invoice("ce10f18e-7cce-4f67-aca5-e2050f965b61").whenHandedOver(new Date()).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)md);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

