/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.dav;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.dav.DavInvoiceBuilder;
import de.gematik.test.erezept.fhir.builder.dav.DavPkvAbgabedatenFaker;
import de.gematik.test.erezept.fhir.builder.dav.DavPkvDispensedMedicationBuilder;
import de.gematik.test.erezept.fhir.builder.dav.PharmacyOrganizationFaker;
import de.gematik.test.erezept.fhir.builder.dav.PriceComponentBuilder;
import de.gematik.test.erezept.fhir.parser.profiles.version.AbdaErpPkvVersion;
import de.gematik.test.erezept.fhir.r4.dav.DavInvoice;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvAbgabedatenBundle;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvDispensedMedication;
import de.gematik.test.erezept.fhir.r4.dav.PharmacyOrganization;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.util.Currency;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.valuesets.dav.KostenVersicherterKategorie;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DavPkvAbgabedatenFakerTest
extends ErpFhirParsingTest {
    DavPkvAbgabedatenFakerTest() {
    }

    @Test
    void buildFakeDavAbgabedatenBundleWithVersion() {
        DavPkvAbgabedatenBundle davBundle = DavPkvAbgabedatenFaker.builder().withVersion(AbdaErpPkvVersion.getDefaultVersion()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)davBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakeDavAbgabedatenBundle() {
        PharmacyOrganization pharmacy = PharmacyOrganizationFaker.builder().fake();
        PrescriptionId prescriptionId = GemFaker.fakerPrescriptionId();
        DavInvoiceBuilder invoiceBuilder = DavInvoiceBuilder.builder().currency(Currency.EUR).status(Invoice.InvoiceStatus.ISSUED).vatRate(GemFaker.vatRate());
        int amountPriceComponents = GemFaker.fakerAmount((int)1, (int)5);
        for (int i = 0; i < amountPriceComponents; ++i) {
            float insurantCost = GemFaker.cost();
            float totalCost = GemFaker.cost((float)insurantCost);
            invoiceBuilder.addPriceComponent(PriceComponentBuilder.builder((KostenVersicherterKategorie)KostenVersicherterKategorie.ZUZAHLUNG).currency(Currency.EUR).type(Invoice.InvoicePriceComponentType.INFORMATIONAL).insurantCost(insurantCost).totalCost(totalCost).build(), (String)PZN.random().getValue(), GemFaker.fakerDrugName());
        }
        DavInvoice invoice = invoiceBuilder.build();
        DavPkvDispensedMedication dispensedMedication = DavPkvDispensedMedicationBuilder.builder().status(MedicationDispense.MedicationDispenseStatus.COMPLETED).prescription(prescriptionId).pharmacy(pharmacy).invoice(invoice).build();
        DavPkvAbgabedatenBundle davBundle = DavPkvAbgabedatenFaker.builder((PrescriptionId)prescriptionId).withDispensedMedication(dispensedMedication, pharmacy, invoice).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)davBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

