/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.dav;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.valueset.Country;
import de.gematik.test.erezept.fhir.builder.dav.DavInvoiceBuilder;
import de.gematik.test.erezept.fhir.builder.dav.DavPkvAbgabedatenBuilder;
import de.gematik.test.erezept.fhir.builder.dav.DavPkvAbgabedatenFaker;
import de.gematik.test.erezept.fhir.builder.dav.DavPkvDispensedMedicationBuilder;
import de.gematik.test.erezept.fhir.builder.dav.PharmacyOrganizationBuilder;
import de.gematik.test.erezept.fhir.builder.dav.PriceComponentBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpBundleFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.AbdaErpPkvVersion;
import de.gematik.test.erezept.fhir.r4.dav.DavInvoice;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvAbgabedatenBundle;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvDispensedMedication;
import de.gematik.test.erezept.fhir.r4.dav.PharmacyOrganization;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.util.Currency;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import de.gematik.test.erezept.fhir.valuesets.dav.KostenVersicherterKategorie;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DavPkvAbgabedatenBuilderTest
extends ErpFhirParsingTest {
    DavPkvAbgabedatenBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build DAV Abgabedatenbundle with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#abdaErpPkvVersions"})
    void buildDavAbgabedatenBundleWithFixedValues(AbdaErpPkvVersion version) {
        PrescriptionId prescriptionId = PrescriptionId.random((PrescriptionFlowType)PrescriptionFlowType.FLOW_TYPE_200);
        KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().withPrescriptionId(prescriptionId).fake();
        PharmacyOrganization pharmacy = ((PharmacyOrganizationBuilder)PharmacyOrganizationBuilder.builder().version(version).name("Adler-Apotheke")).iknr("757299999").address(Country.D, "Berlin", "10623", "Wegelystra\u00dfe 3").build();
        Invoice.InvoiceLineItemPriceComponentComponent pc1 = PriceComponentBuilder.builder((KostenVersicherterKategorie)KostenVersicherterKategorie.ZUZAHLUNG).version(version).currency(Currency.EUR).type("informational").insurantCost(5.8f).totalCost(289.99f).build();
        DavInvoice invoice = DavInvoiceBuilder.builder().version(version).currency(Currency.EUR).status("issued").vatRate(19.0f).addPriceComponent(pc1, "12345678", "Test-Medikament").build();
        DavPkvDispensedMedication dispensedMedication = DavPkvDispensedMedicationBuilder.builder().version(version).status("completed").prescription(prescriptionId).pharmacy(pharmacy).invoice(invoice).build();
        DavPkvAbgabedatenBundle davBundle = DavPkvAbgabedatenBuilder.builder((KbvErpBundle)kbvBundle).version(version).pharmacy(pharmacy).medication(dispensedMedication).invoice(invoice).build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)davBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @RepeatedTest(value=5)
    void shouldBuildValidWithFaker() {
        DavPkvAbgabedatenBundle davBundle = DavPkvAbgabedatenFaker.builder().fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)davBundle);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

