/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.dav;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.dav.DavInvoiceBuilder;
import de.gematik.test.erezept.fhir.builder.dav.PriceComponentBuilder;
import de.gematik.test.erezept.fhir.parser.profiles.definitions.AbdaErpBasisStructDef;
import de.gematik.test.erezept.fhir.parser.profiles.version.AbdaErpPkvVersion;
import de.gematik.test.erezept.fhir.r4.dav.DavInvoice;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.util.Currency;
import de.gematik.test.erezept.fhir.valuesets.dav.KostenVersicherterKategorie;
import java.math.BigDecimal;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DavInvoiceBuilderTest
extends ErpFhirParsingTest {
    DavInvoiceBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build DAV DispensedMedication with E-Rezept FHIR Profiles {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#abdaErpPkvVersions"})
    void buildInvoiceWithFixedValues(AbdaErpPkvVersion version) {
        Invoice.InvoiceLineItemPriceComponentComponent pc1 = PriceComponentBuilder.builder((KostenVersicherterKategorie)KostenVersicherterKategorie.ZUZAHLUNG).version(version).currency(Currency.EUR).type("informational").insurantCost(5.8f).totalCost(289.99f).build();
        Invoice.InvoiceLineItemPriceComponentComponent pc2 = PriceComponentBuilder.builder().version(version).type("informational").insurantCost(4.2f).totalCost(10.01f).factor(200L).build();
        DavInvoice invoice = DavInvoiceBuilder.builder().version(version).currency(Currency.EUR).status("issued").vatRate(19.0f).addPriceComponent(pc1, "11514676", "Amoxicillin/Clavulansure Heumann 875 mg/125 mg 10 St").addPriceComponent(pc2, "87654321", "Asprin").build();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)invoice);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((double)300.0, (double)invoice.getTotalPrice(), (double)0.001);
        Assertions.assertEquals((double)10.0, (double)invoice.getTotalCoPayment(), (double)0.001);
        invoice.getPriceComponents().forEach(pc -> pc.getExtension().stream().filter(xva$0 -> AbdaErpBasisStructDef.MWST_SATZ.matches(new Extension[]{xva$0})).map(ext -> Float.valueOf(((BigDecimal)ext.getValue().castToDecimal((Base)ext.getValue()).getValue()).floatValue())).forEach(vat -> Assertions.assertEquals((double)19.0, (double)vat.floatValue(), (double)0.001)));
    }
}

