/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder;

import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.exceptions.FakerException;
import de.gematik.test.erezept.fhir.extensions.kbv.MultiplePrescriptionExtension;
import de.gematik.test.erezept.fhir.r4.erp.CommunicationType;
import de.gematik.test.erezept.fhir.values.DoctorProfession;
import de.gematik.test.erezept.fhir.valuesets.PayorType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GemFakerTest {
    GemFakerTest() {
    }

    @Test
    void fakerProfessionWorks() {
        String result = GemFaker.fakerProfession();
        Assertions.assertFalse((boolean)result.isEmpty());
    }

    @Test
    void fakerDocProfessionAsStringWorks() {
        String result = GemFaker.fakerDoctorProfessionAsString();
        Assertions.assertFalse((boolean)result.isEmpty());
    }

    @Test
    void fakerDocProfessionWorks() {
        DoctorProfession result = GemFaker.fakerDoctorProfession();
        Assertions.assertFalse((boolean)result.getNaming().isEmpty());
    }

    @Test
    void fakerDoctorProfessionWorks() {
        DoctorProfession doctorProfession = DoctorProfession.VISZERALCHIRURGIE;
        Assertions.assertEquals((Object)"Viszeral Chirurg:in", (Object)doctorProfession.getNaming());
    }

    @Test
    void fakerDoctorProfessionGetDescriptionWorks() {
        String descriptionOfDoctorProfession = DoctorProfession.ANGIOLOGIE.getDescription();
        Assertions.assertFalse((boolean)descriptionOfDoctorProfession.isEmpty());
    }

    @Test
    void emptyDoctorProfessionDescriptionGivesAnswer() {
        String description = DoctorProfession.ALLGEMEINMEDIZIN.getDescription();
        Assertions.assertFalse((boolean)description.isEmpty());
    }

    @Test
    void fakerFutureExpirationShouldBetweenOneAndFourWeeks() {
        Date expirationDate = GemFaker.fakerFutureExpirationDate();
        Date minDate = new Date(new Date().getTime() + TimeUnit.HOURS.toMillis(168L));
        Date maxDate = new Date(new Date().getTime() + TimeUnit.HOURS.toMillis(672L));
        Assertions.assertTrue((expirationDate.getTime() >= minDate.getTime() ? 1 : 0) != 0);
        Assertions.assertTrue((expirationDate.getTime() <= maxDate.getTime() ? 1 : 0) != 0);
    }

    @Test
    void shouldThrowOnConstructorCall() throws NoSuchMethodException {
        Constructor constructor = GemFaker.class.getDeclaredConstructor(new Class[0]);
        Assertions.assertTrue((boolean)Modifier.isPrivate(constructor.getModifiers()));
        constructor.setAccessible(true);
        Assertions.assertThrows(InvocationTargetException.class, () -> {
            GemFaker cfr_ignored_0 = (GemFaker)constructor.newInstance(new Object[0]);
        });
    }

    @Test
    void testInsuranceNameMaxLength() {
        int loopCount = 10;
        for (int i = 0; i < loopCount; ++i) {
            String tmpInsuranceName = GemFaker.insuranceName();
            Assertions.assertTrue((tmpInsuranceName.length() <= 45 ? 1 : 0) != 0);
        }
    }

    @Test
    void testInfoRequest() {
        CommunicationType type = CommunicationType.INFO_REQ;
        String message = GemFaker.fakerCommunicationMessage((CommunicationType)type);
        Assertions.assertTrue((message.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    void testRepresentative() {
        CommunicationType type = CommunicationType.REPRESENTATIVE;
        String message = GemFaker.fakerCommunicationMessage((CommunicationType)type);
        Assertions.assertTrue((message.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    void testDispenseRequest() {
        CommunicationType type = CommunicationType.DISP_REQ;
        String message = GemFaker.fakerCommunicationMessage((CommunicationType)type);
        Assertions.assertTrue((message.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    void testReply() {
        CommunicationType type = CommunicationType.REPLY;
        String message = GemFaker.fakerCommunicationMessage((CommunicationType)type);
        Assertions.assertTrue((message.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    void shouldPickRandomFromValueSet() {
        PayorType e = (PayorType)GemFaker.fakerValueSet(PayorType.class);
        Assertions.assertNotNull((Object)e);
    }

    @Test
    void shouldPickRandomFromValueSetWithExclude() {
        PayorType e = (PayorType)GemFaker.fakerValueSet(PayorType.class, (Enum)PayorType.SKT);
        Assertions.assertNotNull((Object)e);
        Assertions.assertEquals((Object)PayorType.UK, (Object)e);
    }

    @Test
    void shouldPickRandomFromValueSetWithExclude2() {
        List<PayorType> exclude = List.of(PayorType.SKT, PayorType.UK);
        Assertions.assertThrows(FakerException.class, () -> GemFaker.fakerValueSet(PayorType.class, (List)exclude));
    }

    @Test
    void testGenerateControlNoTrue() {
        Assertions.assertEquals((int)5, (int)GemFaker.generateControlNo((String)"456456"));
        Assertions.assertEquals((int)7, (int)GemFaker.generateControlNo((String)"754236"));
    }

    @Test
    void testGenerateContrNoMax() {
        Assertions.assertEquals((int)9, (int)GemFaker.generateControlNo((String)"999999"));
    }

    @Test
    void testGenerateContrNoMin() {
        Assertions.assertEquals((int)1, (int)GemFaker.generateControlNo((String)"1"));
    }

    @Test
    void shouldGenerateRandomSecret() {
        Assertions.assertNotNull((Object)GemFaker.fakerSecret());
    }

    @Test
    void shouldGenerateRandomMvoExtension() {
        MultiplePrescriptionExtension mvo = GemFaker.mvo();
        Assertions.assertNotNull((Object)mvo);
    }

    @Test
    void shouldGenerateRandomUnSetMvoExtension() {
        MultiplePrescriptionExtension mvo = GemFaker.mvo((boolean)false);
        Assertions.assertNotNull((Object)mvo);
        Assertions.assertFalse((boolean)mvo.isMultiple());
    }

    @Test
    void shouldGenerateRandomSetMvoExtension() {
        MultiplePrescriptionExtension mvo = GemFaker.mvo((boolean)true);
        Assertions.assertNotNull((Object)mvo);
        Assertions.assertTrue((boolean)mvo.isMultiple());
        Assertions.assertTrue((mvo.getNumerator() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((mvo.getDenominator() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((mvo.getDenominator() <= 4 ? 1 : 0) != 0);
        Assertions.assertTrue((mvo.getDenominator() >= mvo.getNumerator() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)mvo.getStart().isPresent());
        Assertions.assertNotNull((Object)mvo.getEnd());
    }

    @Test
    void shouldGenerateVatRateInRange() {
        for (int i = 0; i < 10; ++i) {
            float vat = GemFaker.vatRate();
            Assertions.assertTrue((vat >= 10.0f ? 1 : 0) != 0);
            Assertions.assertTrue((vat <= 30.0f ? 1 : 0) != 0);
        }
    }

    @Test
    void shouldThrowOnInvalidVatRanges() {
        Assertions.assertThrows(BuilderException.class, () -> GemFaker.vatRate((float)-0.1f, (float)10.0f));
        Assertions.assertThrows(BuilderException.class, () -> GemFaker.vatRate((float)10.0f, (float)100.1f));
        Assertions.assertThrows(BuilderException.class, () -> GemFaker.vatRate((float)10.0f, (float)10.0f));
        Assertions.assertThrows(BuilderException.class, () -> GemFaker.vatRate((float)15.0f, (float)10.0f));
    }

    @Test
    void shouldGenerateRandomCost() {
        for (int i = 0; i < 10; ++i) {
            float cost = GemFaker.cost();
            Assertions.assertTrue((cost > 0.0f ? 1 : 0) != 0);
        }
    }

    @Test
    void shouldGenerateRandomMinCost() {
        float min = 23.45f;
        for (int i = 0; i < 10; ++i) {
            float cost = GemFaker.cost((float)23.45f);
            Assertions.assertTrue((cost >= 23.45f ? 1 : 0) != 0);
        }
    }

    @Test
    void shouldGenerateRandomRangedCost() {
        float min = 23.45f;
        float max = 324.12f;
        for (int i = 0; i < 10; ++i) {
            float cost = GemFaker.cost((float)23.45f, (float)324.12f);
            Assertions.assertTrue((cost >= 23.45f ? 1 : 0) != 0);
            Assertions.assertTrue((cost <= 324.12f ? 1 : 0) != 0);
        }
    }

    @Test
    void shouldThrowOnInvalidCostRanges() {
        Assertions.assertThrows(BuilderException.class, () -> GemFaker.cost((float)-0.1f, (float)10.0f));
        Assertions.assertThrows(BuilderException.class, () -> GemFaker.cost((float)9.1f, (float)-10.0f));
        Assertions.assertThrows(BuilderException.class, () -> GemFaker.cost((float)90.1f, (float)80.0f));
    }
}

