/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.anonymizer;

import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.anonymizer.AnonymizationType;
import de.gematik.test.erezept.fhir.anonymizer.AnonymizerFacade;
import de.gematik.test.erezept.fhir.anonymizer.BlackingStrategy;
import de.gematik.test.erezept.fhir.anonymizer.CharReplacementStrategy;
import de.gematik.test.erezept.fhir.anonymizer.MaskingStrategy;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPractitioner;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.BaseANR;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class AnonymizerFacadeTest
extends ErpFhirParsingTest {
    AnonymizerFacadeTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldAnonymizeCompleteBundle(String path, AnonymizationType type, MaskingStrategy blacker) {
        String content = ResourceLoader.readFileFromResource((String)path);
        KbvErpBundle bundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        AnonymizerFacade anonymizer = new AnonymizerFacade(type, blacker);
        Boolean anonymization = (Boolean)Assertions.assertDoesNotThrow(() -> anonymizer.anonymize((Resource)bundle));
        Assertions.assertTrue((boolean)anonymization);
    }

    static Stream<Arguments> shouldAnonymizeCompleteBundle() {
        return Stream.of(Arguments.of((Object[])new Object[]{"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml", AnonymizationType.REPLACING, new CharReplacementStrategy()}), Arguments.of((Object[])new Object[]{"fhir/valid/kbv/1.1.0/bundle/3a1c45f8-d959-43f0-8ac4-9959be746188.xml", AnonymizationType.REPLACING, new CharReplacementStrategy()}), Arguments.of((Object[])new Object[]{"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml", AnonymizationType.BLACKING, new CharReplacementStrategy()}), Arguments.of((Object[])new Object[]{"fhir/valid/kbv/1.1.0/bundle/3a1c45f8-d959-43f0-8ac4-9959be746188.xml", AnonymizationType.BLACKING, new CharReplacementStrategy()}), Arguments.of((Object[])new Object[]{"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml", AnonymizationType.REPLACING, new BlackingStrategy()}), Arguments.of((Object[])new Object[]{"fhir/valid/kbv/1.1.0/bundle/3a1c45f8-d959-43f0-8ac4-9959be746188.xml", AnonymizationType.REPLACING, new BlackingStrategy()}));
    }

    @ParameterizedTest
    @ValueSource(strings={"fhir/valid/kbv/1.1.0/bundle/3a1c45f8-d959-43f0-8ac4-9959be746188.xml"})
    void shouldAnonymizePatient(String path) {
        String content = ResourceLoader.readFileFromResource((String)path);
        KbvErpBundle bundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvPatient patient = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.Patient)).map(resource -> (KbvPatient)resource).findFirst().orElseThrow();
        AnonymizerFacade anonymizer = new AnonymizerFacade();
        String originalName = patient.getFullname();
        KVNR originalKvnr = patient.getKvnr();
        Assertions.assertTrue((boolean)anonymizer.anonymize((Resource)patient));
        String anonymizedName = patient.getFullname();
        Assertions.assertNotEquals((Object)originalName, (Object)anonymizedName);
        Assertions.assertEquals((int)originalName.length(), (int)anonymizedName.length());
        KVNR anonymizedKvnr = patient.getKvnr();
        Assertions.assertNotEquals((Object)originalKvnr.getValue(), (Object)anonymizedKvnr.getValue());
        Assertions.assertEquals((int)((String)originalKvnr.getValue()).length(), (int)((String)anonymizedKvnr.getValue()).length());
        Assertions.assertEquals((Object)originalKvnr.getSystemUrl(), (Object)anonymizedKvnr.getSystemUrl());
    }

    @ParameterizedTest
    @ValueSource(strings={"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml", "fhir/valid/kbv/1.1.0/bundle/3a1c45f8-d959-43f0-8ac4-9959be746188.xml"})
    void shouldAnonymizeWithoutFamilyNameExtensions(String path) {
        String content = ResourceLoader.readFileFromResource((String)path);
        KbvErpBundle bundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvPatient patient = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.Patient)).map(resource -> (KbvPatient)resource).findFirst().orElseThrow();
        patient.getName().forEach(hm -> hm.getFamilyElement().setExtension(new LinkedList()));
        AnonymizerFacade anonymizer = new AnonymizerFacade();
        Assertions.assertDoesNotThrow(() -> anonymizer.anonymize((Resource)patient));
    }

    @ParameterizedTest
    @ValueSource(strings={"fhir/valid/kbv/1.0.2/bundle/15da065c-5b75-4acf-a2ba-1355de821d6e.xml", "fhir/valid/kbv/1.1.0/bundle/5f66314e-459a-41e9-a3d7-65c935a8be2c.xml"})
    void shouldAnonymizePractitioner(String path) {
        String content = ResourceLoader.readFileFromResource((String)path);
        KbvErpBundle bundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvPractitioner practitioner = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.Practitioner)).map(resource -> (KbvPractitioner)resource).findFirst().orElseThrow();
        AnonymizerFacade anonymizer = new AnonymizerFacade();
        BaseANR originalANR = practitioner.getANR();
        anonymizer.anonymize((Resource)practitioner);
        BaseANR anonymizedANR = practitioner.getANR();
        Assertions.assertNotEquals((Object)originalANR.getValue(), (Object)anonymizedANR.getValue());
        Assertions.assertEquals((int)originalANR.getValue().length(), (int)anonymizedANR.getValue().length());
        Assertions.assertEquals((Object)originalANR.getCodeSystemUrl(), (Object)anonymizedANR.getCodeSystemUrl());
    }
}

