/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.anonymizer;

import de.gematik.test.erezept.fhir.anonymizer.AnonymizationType;
import de.gematik.test.erezept.fhir.anonymizer.AnonymizerContext;
import de.gematik.test.erezept.fhir.anonymizer.CharReplacementStrategy;
import de.gematik.test.erezept.fhir.anonymizer.MaskingStrategy;
import java.util.Map;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class AnonymizerContextTest {
    AnonymizerContextTest() {
    }

    @Test
    void shouldAnonymizeOnlyStringTypes() {
        AnonymizerContext ctx = new AnonymizerContext(Map.of(), AnonymizationType.REPLACING, (MaskingStrategy)new CharReplacementStrategy());
        IntegerType type = new IntegerType(10);
        Assertions.assertDoesNotThrow(() -> ctx.anonymize((Type)type));
        Assertions.assertEquals((int)10, (Integer)((Integer)type.getValue()));
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldAnonymizeEmptyStringTypes(Type type) {
        AnonymizerContext ctx = new AnonymizerContext(Map.of(), AnonymizationType.REPLACING, (MaskingStrategy)new CharReplacementStrategy());
        Assertions.assertDoesNotThrow(() -> ctx.anonymize(type));
    }

    static Stream<Arguments> shouldAnonymizeEmptyStringTypes() {
        return Stream.of(new StringType(), new StringType("")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

