/*
 * Copyright 2025 gematik GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.gematik.test.erezept.fhir.parser.profiles.definitions;

import de.gematik.bbriccs.fhir.coding.WithStructureDefinition;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvBasisVersion;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum KbvBasisStructDef implements WithStructureDefinition<KbvBasisVersion> {
  BASE_MEDICATION_TYPE("https://fhir.kbv.de/StructureDefinition/KBV_EX_Base_Medication_Type"),
  SUPPORTING_PRESCRIPTION_REF("https://fhir.kbv.de/StructureDefinition/KBV_PR_ERP_Bundle"),
  BINARY("Binary");

  private final String canonicalUrl;
}
