/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.cli.param;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import lombok.Generated;
import picocli.CommandLine;

public class OutputDirectoryParameter {
    @CommandLine.Parameters(arity="0..1", paramLabel="OutputPath", description={"Path to directory where files should be written to.\nIf the output directory is omitted and only an input directory is given, the input and output directories will result in the same path.\nIf neither an input nor an output directory was given, the current user directory will be chosen for the output.\n"})
    protected Path out;

    public OutputDirectoryParameter(Path out) {
        this.out = out;
    }

    public boolean hasSetPath() {
        return this.out != null;
    }

    public Path getOut() {
        if (!this.hasSetPath()) {
            this.out = Path.of(System.getProperty("user.dir"), new String[0]);
        }
        return this.out;
    }

    private Path getAbsolutePath() {
        return this.getOut().toAbsolutePath();
    }

    private String getAbsolutePathString() {
        return this.getAbsolutePath().toString();
    }

    public void writeFile(String filename, String content) {
        File writePath = Path.of(this.getAbsolutePathString(), filename).toFile();
        this.writeFile(writePath, content);
    }

    public void writeFile(String filename, String subdirectory, String content) {
        this.checkInit(subdirectory);
        File writePath = Path.of(this.getAbsolutePathString(), subdirectory, filename).toFile();
        this.writeFile(writePath, content);
    }

    public void writeFile(File file, String content) {
        this.checkInit();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
    }

    private void checkInit() {
        this.checkInit("");
    }

    private void checkInit(String subdirectory) {
        Path fullPath = Path.of(this.getAbsolutePathString(), subdirectory);
        fullPath.toAbsolutePath().toFile().mkdirs();
    }

    @Generated
    public OutputDirectoryParameter() {
    }
}

