/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.cli.param;

import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.test.erezept.cli.param.InputDirectoryParameter;
import de.gematik.test.erezept.cli.param.OutputDirectoryParameter;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import lombok.Generated;
import picocli.CommandLine;

public class InputOutputDirectoryParameter {
    @CommandLine.Mixin
    InputDirectoryParameter input;
    @CommandLine.Mixin
    OutputDirectoryParameter output;

    public Path getOut() {
        this.ensureOutputDirectory();
        return this.output.getOut();
    }

    private void ensureOutputDirectory() {
        if (this.output.out == null) {
            this.output.out = Path.of(this.input.getInputDirectory().toAbsolutePath().toString(), "out");
        }
    }

    public void writeFile(String filename, String content) {
        this.ensureOutputDirectory();
        this.output.writeFile(filename, content);
    }

    public void writeFile(String filename, String subdirectory, String content) {
        this.getOut();
        this.output.writeFile(filename, subdirectory, content);
    }

    @Generated
    public Path getInputDirectory() {
        return this.input.getInputDirectory();
    }

    @Generated
    public boolean hasNext() {
        return this.input.hasNext();
    }

    @Generated
    public File next() throws NoSuchElementException {
        return this.input.next();
    }

    @Generated
    public Path getIn() {
        return this.input.getIn();
    }

    @Generated
    public boolean isRecursive() {
        return this.input.isRecursive();
    }

    @Generated
    public EncodingType getEncodingType() {
        return this.input.getEncodingType();
    }

    @Generated
    public List<Path> getFilePaths() {
        return this.input.getFilePaths();
    }

    @Generated
    public void remove() {
        this.input.remove();
    }

    @Generated
    public void forEachRemaining(Consumer<? super File> action) {
        this.input.forEachRemaining(action);
    }

    @Generated
    public boolean hasSetPath() {
        return this.output.hasSetPath();
    }

    @Generated
    public void writeFile(File file, String content) {
        this.output.writeFile(file, content);
    }

    private static interface DelegateExclude {
        public Path getOut();

        public void writeFile(String var1, String var2, String var3);

        public void writeFile(String var1, String var2);
    }
}

