/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.cli.param;

import de.gematik.bbriccs.fhir.EncodingType;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import picocli.CommandLine;

public class InputDirectoryParameter
implements Iterator<File> {
    private static final List<String> ALWAYS_EXCLUDE = List.of(".DS_Store", "example_details.json", ".gitignore");
    @CommandLine.Parameters(index="0", paramLabel="InputPath", description={"Path to directory where files should be read from"})
    private Path in;
    @CommandLine.Option(names={"-r", "--recursive"}, type={Boolean.class}, description={"Read subdirectories recursively (default=${DEFAULT-VALUE})"})
    private boolean recursive = false;
    @CommandLine.Option(names={"-t", "--file-type"}, paramLabel="<TYPE>", type={EncodingType.class}, description={"Type of encoding which can be either JSON or XML (default=any)"})
    private EncodingType encodingType;
    private List<Path> filePaths;

    public Path getInputDirectory() {
        if (this.in.toFile().isFile()) {
            return this.in.getParent();
        }
        return this.in;
    }

    @Override
    public boolean hasNext() {
        this.checkInit();
        return !this.filePaths.isEmpty();
    }

    @Override
    public File next() throws NoSuchElementException {
        if (this.filePaths == null) {
            throw new NoSuchElementException(MessageFormat.format("Iterator not initialized for {0} / have you called hasNext()?", this.in));
        }
        if (this.filePaths.isEmpty()) {
            throw new NoSuchElementException(MessageFormat.format("No more files in {0} left over to iterate", this.in));
        }
        return this.filePaths.remove(0).toFile();
    }

    private void checkInit() {
        block9: {
            if (this.filePaths != null) break block9;
            if (this.in.toFile().isDirectory()) {
                int maxDepth = this.recursive ? Integer.MAX_VALUE : 1;
                try (Stream<Path> walker = Files.find(this.in, maxDepth, this.createMatcher(), new FileVisitOption[0]);){
                    this.filePaths = walker.filter(f -> !ALWAYS_EXCLUDE.contains(f.toFile().getName())).collect(Collectors.toCollection(LinkedList::new));
                    break block9;
                }
            }
            this.filePaths = new ArrayList<Path>(1);
            this.filePaths.add(this.in.toFile().toPath());
        }
    }

    private BiPredicate<Path, BasicFileAttributes> createMatcher() {
        if (this.encodingType != null) {
            return (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.toString().toLowerCase().endsWith(this.encodingType.toFileExtension());
        }
        return (filePath, fileAttr) -> fileAttr.isRegularFile();
    }

    @Generated
    public Path getIn() {
        return this.in;
    }

    @Generated
    public boolean isRecursive() {
        return this.recursive;
    }

    @Generated
    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    @Generated
    public List<Path> getFilePaths() {
        return this.filePaths;
    }
}

