/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.cli.converter;

import de.gematik.test.erezept.cli.exceptions.CliException;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Stream;
import picocli.CommandLine;

public class StringListConverter
implements CommandLine.ITypeConverter<List<String>> {
    public List<String> convert(String value) throws Exception {
        if (this.isNullOrEmpty(value)) {
            throw new CliException(MessageFormat.format("Given List-Argument is invalid: {0}", value));
        }
        return Stream.of(value.split(",")).filter(v -> !this.isNullOrEmpty((String)v)).map(String::trim).toList();
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.isBlank();
    }
}

