/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.smartcards.tlv;

import de.gematik.smartcards.tlv.BerTlv;
import de.gematik.smartcards.tlv.ConstructedBerTlv;
import de.gematik.smartcards.tlv.DerSpecific;
import de.gematik.smartcards.tlv.PrimitiveBerTlv;
import de.gematik.smartcards.utils.AfiUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
public abstract class PrimitiveSpecific<T>
extends PrimitiveBerTlv
implements DerSpecific {
    protected final List<String> insFindings = new ArrayList<String>();

    protected PrimitiveSpecific(long tag, byte[] valueField) {
        super(tag, valueField);
    }

    protected PrimitiveSpecific(byte[] tag, ByteBuffer buffer) {
        super(tag, buffer);
    }

    protected PrimitiveSpecific(byte[] tag, InputStream inputStream) throws IOException {
        super(tag, inputStream);
    }

    String commentDecoded(int noIndentation, byte[] decoded) {
        try {
            StringBuilder result = new StringBuilder();
            List<BerTlv> list = ((ConstructedBerTlv)PrimitiveSpecific.getInstance((long)250L, (byte[])decoded)).insValueField;
            if (!list.isEmpty()) {
                String indentation = this.indentation("|  ", noIndentation).toString();
                result.append(String.format("%n%s   ##########%n", indentation));
                String[] lines = list.stream().map(BerTlv::toStringTree).collect(Collectors.joining(AfiUtils.LINE_SEPARATOR)).split(AfiUtils.LINE_SEPARATOR);
                result.append(Arrays.stream(lines).map(line -> String.format("%s   # %s", indentation, line)).collect(Collectors.joining(AfiUtils.LINE_SEPARATOR))).append(String.format("%n%s   ##########", indentation));
            }
            return result.toString();
        }
        catch (RuntimeException e) {
            return "";
        }
    }

    public abstract T getDecoded();

    protected final String getFindings() {
        return this.insFindings.isEmpty() ? "" : this.insFindings.stream().collect(Collectors.joining(", ", ", findings: ", ""));
    }

    @Override
    public final boolean isValid() {
        return this.getFindings().isEmpty();
    }
}

